/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditorNotificationProvider
extends EditorNotifications.Provider<InfoPanel> {
    private static final Key<InfoPanel> KEY = Key.create((String)"android.editors.strings");
    private final Project myProject;
    private boolean myShow;

    public StringResourceEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorNotificationProvider", "<init>"));
        }
        this.myProject = project;
        this.myShow = true;
    }

    public Key<InfoPanel> getKey() {
        return KEY;
    }

    @Nullable
    public InfoPanel createNotificationPanel(final @NotNull VirtualFile file, FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringResourceEditorNotificationProvider", "createNotificationPanel"));
        }
        if (!this.myShow || !StringResourceEditorProvider.canViewTranslations(this.myProject, file)) {
            return null;
        }
        final InfoPanel panel = new InfoPanel();
        panel.setText("Edit translations for all locales in the translations editor.");
        panel.createActionLabel("Open editor", new Runnable(){

            @Override
            public void run() {
                StringResourceEditorProvider.openEditor(StringResourceEditorNotificationProvider.this.myProject, file);
            }
        });
        panel.createActionLabel("Hide notification", new Runnable(){

            @Override
            public void run() {
                panel.setVisible(false);
                StringResourceEditorNotificationProvider.this.myShow = false;
            }
        });
        return panel;
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }
}

