/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    private JPanel myPanel;
    private JCheckBox myEnableModuleSelectionOnImportCheckBox;
    private JCheckBox myEnableUnitTestingSupportCheckBox;

    public GradleExperimentalSettingsConfigurable() {
        this.$$$setupUI$$$();
        this.mySettings = GradleExperimentalSettings.getInstance();
    }

    @NotNull
    public String getId() {
        if ("gradle.experimental" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettingsConfigurable", "getId"));
        }
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettingsConfigurable", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT != this.isModuleSelectionOnImportEnabled() || this.mySettings.ENABLE_UNIT_TESTING_SUPPORT != this.isUnitTestingEnabled();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT = this.isModuleSelectionOnImportEnabled();
        this.mySettings.setUnitTestingSupportEnabled(this.isUnitTestingEnabled());
    }

    private boolean isModuleSelectionOnImportEnabled() {
        return this.myEnableModuleSelectionOnImportCheckBox.isSelected();
    }

    private boolean isUnitTestingEnabled() {
        return this.myEnableUnitTestingSupportCheckBox.isSelected();
    }

    public void reset() {
        this.myEnableModuleSelectionOnImportCheckBox.setSelected(this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT);
        this.myEnableUnitTestingSupportCheckBox.setSelected(this.mySettings.ENABLE_UNIT_TESTING_SUPPORT);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> This settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnableModuleSelectionOnImportCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Allow Module selection on Project import");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JXLabel jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jXLabel.setText("When importing a project, select the Modules to be visible in the IDE (helps improve IDE performance when working on big projects.)");
        jPanel.add((Component)jXLabel, new GridConstraints(3, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnableUnitTestingSupportCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable Unit Testing support");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JXLabel jXLabel2 = new JXLabel();
        jXLabel2.setLineWrap(true);
        jXLabel2.setText("Your project needs to use Android Gradle plugin version 1.1.0 (or newer.) You can select the \"Unit Test\" artifact from the \"Build Variants\" tool window. ");
        jPanel.add((Component)jXLabel2, new GridConstraints(6, 0, 1, 1, 0, 1, 1, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

