/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinition {
    private final String myName;
    private final Set<AttributeFormat> myFormats;
    private final List<String> myValues;
    private final Map<String, String> myStyleable2DocValue;
    private String myGlobalDocValue;

    public AttributeDefinition(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        this.myFormats = EnumSet.noneOf(AttributeFormat.class);
        this.myValues = new ArrayList<String>();
        this.myStyleable2DocValue = new HashMap<String, String>();
        this.myName = name;
    }

    public AttributeDefinition(@NotNull String name, @NotNull Collection<AttributeFormat> formats) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "org/jetbrains/android/dom/attrs/AttributeDefinition", "<init>"));
        }
        this.myFormats = EnumSet.noneOf(AttributeFormat.class);
        this.myValues = new ArrayList<String>();
        this.myStyleable2DocValue = new HashMap<String, String>();
        this.myName = name;
        this.myFormats.addAll(formats);
    }

    public void addValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addValue"));
        }
        this.myValues.add(name);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getName"));
        }
        return string;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        Set<AttributeFormat> set = Collections.unmodifiableSet(this.myFormats);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getFormats"));
        }
        return set;
    }

    public void addFormats(@NotNull Collection<AttributeFormat> format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addFormats"));
        }
        this.myFormats.addAll(format);
    }

    @NotNull
    public String[] getValues() {
        String[] stringArray = ArrayUtil.toStringArray(this.myValues);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinition", "getValues"));
        }
        return stringArray;
    }

    @Nullable
    public String getDocValue(@Nullable String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(@NotNull String docValue, @Nullable String parentStyleable) {
        if (docValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docValue", "org/jetbrains/android/dom/attrs/AttributeDefinition", "addDocValue"));
        }
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }
}

