/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.XmlSpellcheckingStrategy;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSpellcheckingStrategy
extends XmlSpellcheckingStrategy {
    private final MyResourceReferenceTokenizer myResourceReferenceTokenizer = new MyResourceReferenceTokenizer();
    private final Tokenizer<XmlAttributeValue> myAttributeValueRenamingTokenizer = new Tokenizer<XmlAttributeValue>(){

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy$1", "tokenize"));
            }
            consumer.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
        }
    };

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "isMyContext"));
        }
        return true;
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (AndroidXmlSpellcheckingStrategy.isAttributeValueContext(element)) {
            Tokenizer tokenizer = this.getAttributeValueTokenizer(element);
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (AndroidXmlSpellcheckingStrategy.inEnglish(element)) {
            Tokenizer tokenizer = super.getTokenizer(element);
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    @NotNull
    public Tokenizer getAttributeValueTokenizer(PsiElement element) {
        GenericAttributeValue domValue;
        String value;
        assert (element instanceof XmlAttributeValue);
        if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
            Tokenizer<XmlAttributeValue> tokenizer = this.myAttributeValueRenamingTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getAttributeValueTokenizer"));
            }
            return tokenizer;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && (value = ((XmlAttribute)parent).getValue()) != null && (domValue = DomManager.getDomManager((Project)parent.getProject()).getDomElement((XmlAttribute)parent)) != null) {
            Converter converter = domValue.getConverter();
            if (converter instanceof ResourceReferenceConverter) {
                MyResourceReferenceTokenizer myResourceReferenceTokenizer = this.myResourceReferenceTokenizer;
                if (myResourceReferenceTokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getAttributeValueTokenizer"));
                }
                return myResourceReferenceTokenizer;
            }
            if (converter instanceof ConstantFieldConverter) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getAttributeValueTokenizer"));
                }
                return tokenizer;
            }
            if (converter instanceof ResourceNameConverter || converter instanceof AndroidPackageConverter) {
                Tokenizer<XmlAttributeValue> tokenizer = this.myAttributeValueRenamingTokenizer;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getAttributeValueTokenizer"));
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "getAttributeValueTokenizer"));
        }
        return tokenizer;
    }

    private static boolean isAttributeValueContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "isAttributeValueContext"));
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        PsiElement psiElement = parent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlTag)parent);
        if (domElement instanceof AndroidDomElement) {
            return AndroidXmlSpellcheckingStrategy.inEnglish(element);
        }
        return false;
    }

    private static boolean inEnglish(PsiElement element) {
        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class);
        if (file != null) {
            PsiDirectory dir;
            String name = file.getName();
            if (name.equals("AndroidManifest.xml")) {
                return true;
            }
            if (name.equals("generated.xml")) {
                VirtualFile buildFolder;
                IdeaAndroidProject project;
                AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
                VirtualFile virtualFile = file.getVirtualFile();
                if (facet != null && facet.isGradleProject() && virtualFile != null && (project = facet.getIdeaAndroidProject()) != null && (buildFolder = VfsUtil.findFileByIoFile((File)project.getDelegate().getBuildFolder(), (boolean)false)) != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)virtualFile, (boolean)false)) {
                    return false;
                }
            }
            if ((dir = file.getParent()) != null) {
                String locale = LintUtils.getLocaleAndRegion((String)dir.getName());
                if (locale == null) {
                    locale = AndroidXmlSpellcheckingStrategy.getToolsLocale(file);
                }
                return locale == null || locale.startsWith("en") || locale.equals("b+en") || locale.startsWith("b+en+");
            }
        }
        return false;
    }

    @Nullable
    private static String getToolsLocale(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null) {
            return rootTag.getAttributeValue("locale", "http://schemas.android.com/tools");
        }
        return null;
    }

    private static boolean isColorString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy", "isColorString"));
        }
        int length = s.length();
        if (length < 4 || length > 9) {
            return false;
        }
        int i = 0;
        if (s.charAt(i++) != '#') {
            return false;
        }
        while (i < length) {
            if (!StringUtil.isHexDigit((char)s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class MyResourceReferenceTokenizer
    extends SpellcheckingStrategy.XmlAttributeValueTokenizer {
        private MyResourceReferenceTokenizer() {
        }

        @Nullable
        private static AndroidResourceReferenceBase findResourceReference(PsiElement element) {
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof AndroidResourceReferenceBase)) continue;
                return (AndroidResourceReferenceBase)reference;
            }
            return null;
        }

        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidXmlSpellcheckingStrategy$MyResourceReferenceTokenizer", "tokenize"));
            }
            AndroidResourceReferenceBase reference = MyResourceReferenceTokenizer.findResourceReference((PsiElement)element);
            if (reference != null) {
                if (reference.getResourceValue().getPackage() == null) {
                    consumer.consumeToken((PsiElement)element, true, (Splitter)TextSplitter.getInstance());
                }
                return;
            }
            if (AndroidXmlSpellcheckingStrategy.isColorString(element.getValue())) {
                return;
            }
            super.tokenize(element, consumer);
        }
    }
}

