/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class InaccessibleElementVisitor
extends GroovyRecursiveElementVisitor {
    private final GrAccessibilityChecker myReferenceChecker;
    private final List<HighlightInfo> myInfos;

    public InaccessibleElementVisitor(GroovyFileBase file, Project project, List<HighlightInfo> collector) {
        this.myReferenceChecker = new GrAccessibilityChecker(file, project);
        this.myInfos = collector;
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        HighlightInfo info;
        int size = this.myInfos.size();
        super.visitReferenceExpression(referenceExpression);
        if (size == this.myInfos.size() && (info = this.myReferenceChecker.checkReferenceExpression(referenceExpression)) != null) {
            this.myInfos.add(info);
        }
    }

    @Override
    public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
        HighlightInfo info;
        int size = this.myInfos.size();
        super.visitCodeReferenceElement(refElement);
        if (size == this.myInfos.size() && (info = this.myReferenceChecker.checkCodeReferenceElement(refElement)) != null) {
            this.myInfos.add(info);
        }
    }
}

