/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.spike;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.specs.Spec;
import org.gradle.model.dsl.internal.spike.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelRegistry {
    private Map<ModelPath, ModelCreator> creators = Maps.newHashMap();

    ModelRegistry() {
    }

    public void create(ModelPath path, ModelCreator creator) {
        this.creators.put(path, creator);
    }

    private Set<ModelPath> getPromisedPaths() {
        return ImmutableSet.builder().addAll(this.creators.keySet()).build();
    }

    public Object get(ModelPath path) {
        ModelCreator modelCreator = this.creators.get(path);
        ImmutableMap inputs = Maps.toMap(modelCreator.getInputPaths(), (Function)new Function<String, Object>(){

            public Object apply(String inputPath) {
                return ModelRegistry.this.get(ModelPath.path((String)inputPath));
            }
        });
        Object result = modelCreator.create((Map<String, Object>)inputs);
        Set<ModelPath> promisedPaths = this.getPromisedPaths();
        for (ModelPath modelPath : promisedPaths) {
            if (!path.isDirectChild(modelPath)) continue;
            this.closeChild(result, modelPath);
        }
        return result;
    }

    private void closeChild(Object parent, ModelPath childPath) {
        try {
            String fieldName = childPath.getName();
            final String setterName = String.format("set%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
            Method setter = (Method)CollectionUtils.findFirst((Object[])parent.getClass().getDeclaredMethods(), (Spec)new Spec<Method>(){

                public boolean isSatisfiedBy(Method method) {
                    return method.getName().equals(setterName);
                }
            });
            setter.invoke(parent, this.get(childPath));
        }
        catch (Exception e) {
            throw new GradleException("Could not close model element children", (Throwable)e);
        }
    }
}

