/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementMethodsFix;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementAbstractClassMethodsFix
extends ImplementMethodsFix {
    public ImplementAbstractClassMethodsFix(PsiElement highlightElement) {
        super(highlightElement);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "isAvailable"));
        }
        if (startElement instanceof PsiNewExpression) {
            block10: {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                String startElementText = startElement.getText();
                try {
                    PsiNewExpression newExpression = (PsiNewExpression)elementFactory.createExpressionFromText(startElementText + "{}", startElement);
                    if (newExpression.getAnonymousClass() != null) break block10;
                    try {
                        newExpression = (PsiNewExpression)elementFactory.createExpressionFromText(startElementText + "){}", startElement);
                    }
                    catch (IncorrectOperationException e) {
                        return false;
                    }
                    if (newExpression.getAnonymousClass() == null) {
                        return false;
                    }
                }
                catch (IncorrectOperationException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void invoke(final @NotNull Project project, @NotNull PsiFile file, final @Nullable(value="is null when called from inspection") Editor editor, final @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ImplementAbstractClassMethodsFix", "invoke"));
        }
        PsiFile containingFile = startElement.getContainingFile();
        if (editor == null || !FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)startElement).getClassReference();
        if (classReference == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)classReference.resolve();
        if (psiClass == null) {
            return;
        }
        final MemberChooser<PsiMethodMember> chooser = ImplementAbstractClassMethodsFix.chooseMethodsToImplement(editor, startElement, psiClass, false);
        if (chooser == null) {
            return;
        }
        final List<PsiMethodMember> selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[]{file}){

            protected void run(Result result) throws Throwable {
                PsiNewExpression newExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(startElement.getText() + "{}", startElement);
                PsiAnonymousClass psiClass = (newExpression = (PsiNewExpression)startElement.replace((PsiElement)newExpression)).getAnonymousClass();
                if (psiClass == null) {
                    return;
                }
                HashMap<PsiClass, PsiSubstitutor> subst = new HashMap<PsiClass, PsiSubstitutor>();
                for (PsiMethodMember selectedElement : selectedElements) {
                    PsiClass baseClass = ((PsiMethod)selectedElement.getElement()).getContainingClass();
                    if (baseClass == null) continue;
                    PsiSubstitutor substitutor = (PsiSubstitutor)subst.get(baseClass);
                    if (substitutor == null) {
                        substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                        subst.put(baseClass, substitutor);
                    }
                    selectedElement.setSubstitutor(substitutor);
                }
                OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, (PsiClass)psiClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation());
            }
        }.execute();
    }
}

