/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public class MissingMethodBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiElement;
        PsiClass containingClass = method.getContainingClass();
        if (!MissingMethodBodyFixer.shouldHaveBody(method)) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        Document doc = editor.getDocument();
        if (body != null) {
            PsiStatement[] statements;
            String bodyText = body.getText();
            if (bodyText.startsWith("{") && (statements = body.getStatements()).length > 0 && statements[0] instanceof PsiDeclarationStatement && PsiTreeUtil.getDeepestLast((PsiElement)statements[0]) instanceof PsiErrorElement && containingClass.getRBrace() == null) {
                doc.insertString(body.getTextRange().getStartOffset() + 1, (CharSequence)"\n}");
            }
            return;
        }
        int endOffset = method.getThrowsList().getTextRange().getEndOffset();
        if (endOffset < doc.getTextLength() && doc.getCharsSequence().charAt(endOffset) == ';') {
            doc.deleteString(endOffset, endOffset + 1);
        }
        doc.insertString(endOffset, (CharSequence)"{\n}");
    }

    static boolean shouldHaveBody(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (method.hasModifierProperty("private")) {
            return true;
        }
        if (method.hasModifierProperty("abstract") || method.hasModifierProperty("native")) {
            return false;
        }
        return !containingClass.isInterface() || method.hasModifierProperty("default") || method.hasModifierProperty("static");
    }
}

