/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    private static final String GROUP_DISPLAY_NAME = "";
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"illegal.package.dependencies", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "Dependency";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        if (GROUP_DISPLAY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getGroupDisplayName"));
        }
        return GROUP_DISPLAY_NAME;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "checkFile"));
        }
        if (file.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE) == null) {
            return null;
        }
        final DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)file.getProject());
        if (!validationManager.hasRules()) {
            return null;
        }
        if (validationManager.getApplicableRules(file).length == 0) {
            return null;
        }
        ArrayList problems = new ArrayList();
        FactoryMap<PsiFile, DependencyRule[]> violations = new FactoryMap<PsiFile, DependencyRule[]>(){

            @Nullable
            protected DependencyRule[] create(PsiFile dependencyFile) {
                return validationManager.getViolatorDependencyRules(file, dependencyFile);
            }
        };
        DependenciesBuilder.analyzeFileDependencies(file, new DependenciesBuilder.DependencyProcessor((FactoryMap)violations, problems, manager, isOnTheFly){
            final /* synthetic */ FactoryMap val$violations;
            final /* synthetic */ List val$problems;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$violations = factoryMap;
                this.val$problems = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
                    for (DependencyRule dependencyRule : (DependencyRule[])this.val$violations.get((Object)dependencyFile)) {
                        this.val$problems.add(this.val$manager.createProblemDescriptor(place, InspectionsBundle.message((String)"inspection.dependency.violator.problem.descriptor", (Object[])new Object[]{dependencyRule.getDisplayText()}), this.val$isOnTheFly, DependencyInspectionBase.this.createEditDependencyFixes(dependencyRule), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return null;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

