/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectCollectedException;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerContextCommandImpl
extends SuspendContextCommandImpl {
    private static final Logger LOG = Logger.getInstance(DebuggerContextCommandImpl.class);
    private final DebuggerContextImpl myDebuggerContext;

    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext) {
        if (debuggerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/engine/events/DebuggerContextCommandImpl", "<init>"));
        }
        super(debuggerContext.getSuspendContext());
        this.myDebuggerContext = debuggerContext;
    }

    public final DebuggerContextImpl getDebuggerContext() {
        return this.myDebuggerContext;
    }

    @Override
    public final void contextAction() throws Exception {
        boolean isSuspendedByContext;
        SuspendManager suspendManager = this.myDebuggerContext.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl debuggerContextThread = this.myDebuggerContext.getThreadProxy();
        try {
            isSuspendedByContext = suspendManager.isSuspended(debuggerContextThread);
        }
        catch (ObjectCollectedException ignored) {
            this.notifyCancelled();
            return;
        }
        if (isSuspendedByContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context thread " + this.getSuspendContext().getThread());
                LOG.debug("Debug thread" + debuggerContextThread);
            }
            this.threadAction();
        } else {
            SuspendContextImpl suspendContextForThread = SuspendManagerUtil.findContextByThread(suspendManager, debuggerContextThread);
            if (suspendContextForThread != null) {
                suspendContextForThread.postponeCommand(this);
            } else {
                this.notifyCancelled();
            }
        }
    }

    public abstract void threadAction();
}

