/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DiffDividerDrawUtil {
    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    public static void paintSeparatorsOnScrollbar(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paintOnScrollbar(gg, width);
        }
        config.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, true, editor1, editor2, paintable);
    }

    public static void paintSimplePolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, false, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean paintBorder, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, paintBorder, curved);
        }
        config.restore();
    }

    public static void paintPolygonsOnScrollbar(@NotNull Graphics2D g, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        for (DividerPolygon polygon : polygons) {
            polygon.paintOnScrollbar(g, width);
        }
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        final Interval leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final Interval rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$1", "process"));
                }
                if (leftInterval.startLine > endLine1 && rightInterval.startLine > endLine2) {
                    return true;
                }
                if (leftInterval.endLine < startLine1 && rightInterval.endLine < startLine2) {
                    return false;
                }
                polygons.add(DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color));
                return true;
            }
        });
        ArrayList<DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        return arrayList;
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        final ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        final Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        final Interval leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final Interval rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        final int height1 = editor1.getLineHeight();
        final int height2 = editor2.getLineHeight();
        paintable.process(new DividerSeparatorPaintable.Handler(){

            @Override
            public boolean process(int line1, int line2) {
                if (leftInterval.startLine > line1 + 1 && rightInterval.startLine > line2 + 1) {
                    return true;
                }
                if (leftInterval.endLine < line1 && rightInterval.endLine < line2) {
                    return false;
                }
                separators.add(DiffDividerDrawUtil.createSeparator(transformations, line1, line2, height1, height2));
                return true;
            }
        });
        ArrayList<DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDividerDrawUtil", "getTransformation"));
        }
        Transformation transformation = new Transformation(){

            @Override
            public int transform(int line) {
                int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
                JComponent header = editor.getHeaderComponent();
                int headerOffset = header == null ? 0 : header.getHeight();
                return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
            }
        };
        if (transformation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getTransformation"));
        }
        return transformation;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        DividerPolygon dividerPolygon = new DividerPolygon(start1, start2, end1, end2, color);
        if (dividerPolygon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        return dividerPolygon;
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Transformation[] transformations, int line1, int line2, int height1, int height2) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/diff/util/DiffDividerDrawUtil", "createSeparator"));
        }
        int start1 = transformations[0].transform(line1);
        int start2 = transformations[1].transform(line2);
        DividerSeparator dividerSeparator = new DividerSeparator(start1, start2, start1 + height1, start2 + height2);
        if (dividerSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createSeparator"));
        }
        return dividerSeparator;
    }

    @NotNull
    private static Interval getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        Interval interval = new Interval(position1.line, position2.line);
        if (interval == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getVisibleInterval"));
        }
        return interval;
    }

    private static class Interval {
        public final int startLine;
        public final int endLine;

        public Interval(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;

        public DividerSeparator(int start1, int start2, int end1, int end2) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
        }

        private void paint(Graphics2D g, int width) {
            DiffDrawUtil.drawConnectorLineSeparator(g, 0, width, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2);
        }

        private void paintOnScrollbar(Graphics2D g, int width) {
            DiffDrawUtil.drawConnectorLineSeparator(g, 0, width, this.myStart1, this.myEnd1, this.myStart1, this.myEnd1);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @NotNull
        private final Color myColor;

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon", "<init>"));
            }
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myColor = color;
        }

        private void paint(Graphics2D g, int width, boolean paintBorder, boolean curve) {
            Color borderColor;
            Color color = borderColor = paintBorder ? DiffDrawUtil.getFramingColor(this.myColor) : this.myColor;
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, this.myStart1 - 1, this.myEnd1 - 1, this.myStart2 - 1, this.myEnd2 - 1, this.myColor, borderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, this.myStart1 - 1, this.myEnd1 - 1, this.myStart2 - 1, this.myEnd2 - 1, this.myColor, borderColor);
            }
        }

        private void paintOnScrollbar(Graphics2D g, int width) {
            int startY = this.myStart1 - 1;
            int endY = this.myEnd1 - 1;
            int height = endY - startY;
            int startX = 0;
            int endX = startX + width - 1;
            g.setColor(this.myColor);
            if (height > 2) {
                g.fillRect(startX, startY, width, height);
                Color framingColor = DiffDrawUtil.getFramingColor(this.myColor);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)startY, (int)endX, (int)startY, null, (Color)framingColor);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)endY, (int)endX, (int)endY, null, (Color)framingColor);
            } else {
                DiffDrawUtil.drawDoubleShadowedLine(g, startX, endX, startY, this.myColor);
            }
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5);
        }
    }
}

