/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewBuilderProvider;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFileTypeStructureViewBuilderProvider
implements StructureViewBuilderProvider {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull FileType fileType, @NotNull VirtualFile file, @NotNull Project project) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/LanguageFileTypeStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/LanguageFileTypeStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/highlighter/LanguageFileTypeStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiFile.getLanguage());
        return factory == null ? null : factory.getStructureViewBuilder(psiFile);
    }
}

