/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.ScopeBasedTodosTreeBuilder;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class ScopeBasedTodosPanel
extends TodoPanel {
    private static final String SELECTED_SCOPE = "TODO_SCOPE";
    private final Alarm myAlarm;
    private ScopeChooserCombo myScopes;

    public ScopeBasedTodosPanel(Project project, TodoPanelSettings settings, Content content) {
        super(project, settings, false, content);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        ((JComboBox)this.myScopes.getChildComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeBasedTodosPanel.this.rebuildWithAlarm(ScopeBasedTodosPanel.this.myAlarm);
                String selectedItemName = ScopeBasedTodosPanel.this.myScopes.getSelectedScopeName();
                if (selectedItemName != null) {
                    PropertiesComponent.getInstance((Project)ScopeBasedTodosPanel.this.myProject).setValue(ScopeBasedTodosPanel.SELECTED_SCOPE, selectedItemName);
                }
            }
        });
        this.rebuildWithAlarm(this.myAlarm);
    }

    @Override
    protected JComponent createCenterComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JComponent component = super.createCenterComponent();
        panel.add((Component)component, "Center");
        String preselect = PropertiesComponent.getInstance((Project)this.myProject).getValue(SELECTED_SCOPE);
        this.myScopes = new ScopeChooserCombo(this.myProject, false, true, preselect);
        this.myScopes.setCurrentSelection(false);
        this.myScopes.setUsageView(false);
        JPanel chooserPanel = new JPanel(new GridBagLayout());
        JLabel scopesLabel = new JLabel("Scope:");
        scopesLabel.setDisplayedMnemonic('S');
        scopesLabel.setLabelFor((Component)((Object)this.myScopes));
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
        chooserPanel.add((Component)scopesLabel, gc);
        chooserPanel.add((Component)((Object)this.myScopes), gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        chooserPanel.add((Component)Box.createHorizontalBox(), gc);
        panel.add((Component)chooserPanel, "North");
        return panel;
    }

    @Override
    protected TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
        ScopeBasedTodosTreeBuilder builder = new ScopeBasedTodosTreeBuilder(tree, treeModel, project, this.myScopes);
        builder.init();
        return builder;
    }
}

