/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Insets ins = this.getBorderInsets(c);
        int yOff = (ins.top + ins.bottom) / 4;
        boolean square = DarculaButtonUI.isSquare(c);
        int offset = JBUI.scale((int)(square ? 1 : this.getOffset()));
        int w = c.getWidth();
        int h = c.getHeight();
        int diam = JBUI.scale((int)22);
        if (c.hasFocus()) {
            if (DarculaButtonUI.isHelpButton((JComponent)c)) {
                DarculaUIUtil.paintFocusOval(g2d, (w - diam) / 2, (h - diam) / 2, diam, diam);
            } else {
                DarculaUIUtil.paintFocusRing(g2d, offset, yOff, width - 2 * offset, height - 2 * yOff);
            }
        } else {
            GraphicsConfig config = new GraphicsConfig(g);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2d.setPaint(UIUtil.getGradientPaint((float)(width / 2), (float)(y + yOff + JBUI.scale((int)1)), (Color)Gray._80.withAlpha(90), (float)(width / 2), (float)(height - 2 * yOff), (Color)Gray._90.withAlpha(90)));
            ((Graphics2D)g).setPaint(Gray._100.withAlpha(180));
            if (DarculaButtonUI.isHelpButton((JComponent)c)) {
                g.drawOval((w - diam) / 2, (h - diam) / 2, diam, diam);
            } else {
                g.translate(x, y);
                int r = JBUI.scale((int)(square ? 3 : 5));
                g.drawRoundRect(offset, yOff, width - 2 * offset, height - 2 * yOff, r, r);
                g.translate(-x, -y);
            }
            config.restore();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)2, (int)0, (int)2, (int)0).asUIResource();
        }
        return JBUI.insets((int)8, (int)16, (int)8, (int)14).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

