/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class GotoFileCellRenderer
extends PsiElementListCellRenderer<PsiFileSystemItem> {
    private final int myMaxWidth;

    public GotoFileCellRenderer(int maxSize) {
        this.myMaxWidth = maxSize;
    }

    @Override
    public String getElementText(PsiFileSystemItem element) {
        return element.getName();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == "non-prefix matches:") {
            Object previousElement = index > 0 ? list.getModel().getElementAt(index - 1) : null;
            return ChooseByNameBase.renderNonPrefixSeparatorComponent(GotoFileCellRenderer.getBackgroundColor(previousElement));
        }
        Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font editorFont = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
        this.setFont(editorFont);
        return component;
    }

    @Override
    protected String getContainerText(PsiFileSystemItem element, String name) {
        PsiDirectory psiDirectory;
        PsiFileSystemItem parent = element.getParent();
        PsiDirectory psiDirectory2 = psiDirectory = parent instanceof PsiDirectory ? (PsiDirectory)parent : null;
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        String relativePath = GotoFileCellRenderer.getRelativePath(virtualFile, element.getProject());
        if (relativePath == null) {
            return "( " + File.separator + " )";
        }
        String path = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name + "          ", new File(relativePath), (JComponent)this, this.myMaxWidth);
        return "(" + path + ")";
    }

    @Nullable
    static String getRelativePath(VirtualFile virtualFile, Project project) {
        String projectHomeUrl;
        String url = virtualFile.getPresentableUrl();
        if (project == null) {
            return url;
        }
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(virtualFile);
        if (root != null) {
            return root.getName() + File.separatorChar + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root, (char)File.separatorChar);
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            String cont = url.substring(projectHomeUrl.length());
            if (cont.isEmpty()) {
                return null;
            }
            url = "..." + cont;
        }
        return url;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (!(value instanceof NavigationItem)) {
            return false;
        }
        NavigationItem item = (NavigationItem)value;
        TextAttributes attributes = GotoFileCellRenderer.getNavigationItemAttributes(item);
        SimpleTextAttributes nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
        Color color = list.getForeground();
        if (nameAttributes == null) {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        renderer.append(item + " ", nameAttributes);
        ItemPresentation itemPresentation = item.getPresentation();
        assert (itemPresentation != null);
        renderer.setIcon(itemPresentation.getIcon(true));
        String locationString = itemPresentation.getLocationString();
        if (!StringUtil.isEmpty((String)locationString)) {
            renderer.append(locationString, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
        return true;
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

