/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class TextBasedSoftWrapPainter
implements SoftWrapPainter {
    private final Map<SoftWrapDrawingType, char[]> mySymbols = new EnumMap<SoftWrapDrawingType, char[]>(SoftWrapDrawingType.class);
    private final Map<SoftWrapDrawingType, FontInfo> myFonts = new EnumMap<SoftWrapDrawingType, FontInfo>(SoftWrapDrawingType.class);
    private final int[] myWidths = new int[SoftWrapDrawingType.values().length];
    private final Map<SoftWrapDrawingType, Integer> myVGaps = new EnumMap<SoftWrapDrawingType, Integer>(SoftWrapDrawingType.class);
    private final TextDrawingCallback myDrawingCallback;
    private final ColorProvider myColorHolder;
    private boolean myCanUse;
    private final Editor myEditor;

    public TextBasedSoftWrapPainter(Map<SoftWrapDrawingType, Character> symbols, Editor editor, TextDrawingCallback drawingCallback, ColorProvider colorHolder) throws IllegalArgumentException {
        if (symbols.size() != SoftWrapDrawingType.values().length) {
            throw new IllegalArgumentException(String.format("Can't create text-based soft wrap painter. Reason: given 'drawing type -> symbol' mappings are incomplete - expected size %d but got %d (%s)", SoftWrapDrawingType.values().length, symbols.size(), symbols));
        }
        this.myEditor = editor;
        this.myDrawingCallback = drawingCallback;
        this.myColorHolder = colorHolder;
        for (Map.Entry<SoftWrapDrawingType, Character> entry : symbols.entrySet()) {
            this.mySymbols.put(entry.getKey(), new char[]{entry.getValue().charValue()});
        }
        this.reinit();
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/TextBasedSoftWrapPainter", "paint"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/TextBasedSoftWrapPainter", "paint"));
        }
        FontInfo fontInfo = this.myFonts.get((Object)drawingType);
        if (fontInfo != null) {
            char[] buffer = this.mySymbols.get((Object)drawingType);
            int vGap = this.myVGaps.get((Object)drawingType);
            this.myDrawingCallback.drawChars(g, buffer, 0, buffer.length, x, y + lineHeight - vGap, this.myColorHolder.getColor(), fontInfo);
        }
        return this.getMinDrawingWidth(drawingType);
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/TextBasedSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/TextBasedSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        return this.getMinDrawingWidth(drawingType);
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/TextBasedSoftWrapPainter", "getMinDrawingWidth"));
        }
        return this.myWidths[drawingType.ordinal()];
    }

    @Override
    public boolean canUse() {
        return this.myCanUse;
    }

    @Override
    public void reinit() {
        JLabel component = new JLabel();
        this.myCanUse = true;
        for (Map.Entry<SoftWrapDrawingType, char[]> entry : this.mySymbols.entrySet()) {
            SoftWrapDrawingType type = entry.getKey();
            char c = entry.getValue()[0];
            FontInfo fontInfo = EditorUtil.fontForChar(c, 0, this.myEditor);
            if (!fontInfo.canDisplay(c)) {
                this.myCanUse = false;
                this.myFonts.put(type, null);
                this.myVGaps.put(type, null);
                this.myWidths[type.ordinal()] = 0;
                continue;
            }
            this.myFonts.put(type, fontInfo);
            FontMetrics metrics = component.getFontMetrics(fontInfo.getFont());
            this.myWidths[type.ordinal()] = metrics.charWidth(c);
            int vGap = metrics.getDescent();
            this.myVGaps.put(type, vGap);
        }
    }
}

