/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.LightFilePointer;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLibraryEditor
extends LibraryEditorBase {
    private String myLibraryName;
    private final MultiMap<OrderRootType, LightFilePointer> myRoots;
    private final Set<LightFilePointer> myExcludedRoots;
    private final JarDirectories myJarDirectories = new JarDirectories();
    private LibraryType myType;
    private LibraryProperties myProperties;

    public NewLibraryEditor() {
        this(null, null);
    }

    public NewLibraryEditor(@Nullable LibraryType type, @Nullable LibraryProperties properties) {
        this.myType = type;
        this.myProperties = properties;
        this.myRoots = new MultiMap();
        this.myExcludedRoots = new LinkedHashSet<LightFilePointer>();
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return this.myRoots.keySet();
    }

    @Override
    @Nullable
    public LibraryType<?> getType() {
        return this.myType;
    }

    @Override
    public void setType(@NotNull LibraryType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "setType"));
        }
        this.myType = type;
    }

    @Override
    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myProperties = properties;
    }

    @Override
    public String getName() {
        return this.myLibraryName;
    }

    @Override
    public String[] getUrls(OrderRootType rootType) {
        return NewLibraryEditor.pointersToUrls(this.myRoots.get((Object)rootType));
    }

    private static String[] pointersToUrls(Collection<LightFilePointer> pointers) {
        ArrayList<String> urls = new ArrayList<String>(pointers.size());
        for (LightFilePointer pointer : pointers) {
            urls.add(pointer.getUrl());
        }
        return ArrayUtil.toStringArray(urls);
    }

    @Override
    public VirtualFile[] getFiles(OrderRootType rootType) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (LightFilePointer pointer : this.myRoots.get((Object)rootType)) {
            String url;
            VirtualFile file = pointer.getFile();
            if (file == null) continue;
            if (file.isDirectory() && this.myJarDirectories.contains(rootType, url = file.getUrl())) {
                LibraryImpl.collectJarFiles(file, result, this.myJarDirectories.isRecursive(rootType, url));
                continue;
            }
            result.add(file);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Override
    public String[] getExcludedRootUrls() {
        return NewLibraryEditor.pointersToUrls(this.myExcludedRoots);
    }

    @Override
    public void setName(String name) {
        this.myLibraryName = name;
    }

    @Override
    public void addRoot(VirtualFile file, OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(file));
    }

    @Override
    public void addRoot(String url, OrderRootType rootType) {
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(url));
    }

    @Override
    public void addJarDirectory(VirtualFile file, boolean recursive, OrderRootType rootType) {
        this.addJarDirectory(file.getUrl(), recursive, rootType);
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "addExcludedRoot"));
        }
        this.myExcludedRoots.add(new LightFilePointer(url));
    }

    @Override
    public void removeExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "removeExcludedRoot"));
        }
        this.myExcludedRoots.remove(new LightFilePointer(url));
    }

    @Override
    public void addJarDirectory(String url, boolean recursive, OrderRootType rootType) {
        this.addRoot(url, rootType);
        this.myJarDirectories.add(rootType, url, recursive);
    }

    @Override
    public void removeRoot(String url, OrderRootType rootType) {
        this.myRoots.remove((Object)rootType, (Object)new LightFilePointer(url));
        Iterator<LightFilePointer> iterator = this.myExcludedRoots.iterator();
        while (iterator.hasNext()) {
            LightFilePointer pointer = iterator.next();
            if (this.isUnderRoots(pointer.getUrl())) continue;
            iterator.remove();
        }
        this.myJarDirectories.remove(rootType, url);
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor", "isUnderRoots"));
        }
        for (LightFilePointer pointer : this.myRoots.values()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)pointer.getUrl(), (String)url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanges() {
        return true;
    }

    @Override
    public boolean isJarDirectory(String url, OrderRootType rootType) {
        return this.myJarDirectories.contains(rootType, url);
    }

    @Override
    public boolean isValid(String url, OrderRootType orderRootType) {
        Collection pointers = this.myRoots.get((Object)orderRootType);
        for (LightFilePointer pointer : pointers) {
            if (!pointer.getUrl().equals(url)) continue;
            return pointer.isValid();
        }
        return false;
    }

    public void applyTo(LibraryEx.ModifiableModelEx model) {
        model.setProperties(this.myProperties);
        for (OrderRootType type : this.myRoots.keySet()) {
            for (LightFilePointer pointer : this.myRoots.get((Object)type)) {
                if (this.myJarDirectories.contains(type, pointer.getUrl())) continue;
                model.addRoot(pointer.getUrl(), type);
            }
        }
        for (OrderRootType rootType : this.myJarDirectories.getRootTypes()) {
            for (String url : this.myJarDirectories.getDirectories(rootType)) {
                model.addJarDirectory(url, this.myJarDirectories.isRecursive(rootType, url), rootType);
            }
        }
    }

    public void applyTo(LibraryEditorBase editor) {
        editor.setProperties(this.myProperties);
        for (OrderRootType type : this.myRoots.keySet()) {
            for (LightFilePointer pointer : this.myRoots.get((Object)type)) {
                if (this.myJarDirectories.contains(type, pointer.getUrl())) continue;
                editor.addRoot(pointer.getUrl(), type);
            }
        }
        for (OrderRootType rootType : this.myJarDirectories.getRootTypes()) {
            for (String url : this.myJarDirectories.getDirectories(rootType)) {
                editor.addJarDirectory(url, this.myJarDirectories.isRecursive(rootType, url), rootType);
            }
        }
    }
}

