/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiEnumConstantImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiEnumConstant {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiEnumConstantImpl");
    private final MyReference myReference = new MyReference();

    public PsiEnumConstantImpl(PsiFieldStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ENUM_CONSTANT);
    }

    public PsiEnumConstantImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return "PsiEnumConstant:" + this.getName();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitEnumConstant((PsiEnumConstant)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.calcTreeElement().findChildByRoleAsPsiElement(73);
    }

    public PsiEnumConstantInitializer getInitializingClass() {
        return (PsiEnumConstantInitializer)this.getStubOrPsiChild(JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    @NotNull
    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        PsiEnumConstantInitializer initializingClass = this.getInitializingClass();
        if (initializingClass != null) {
            PsiEnumConstantInitializer psiEnumConstantInitializer = initializingClass;
            if (psiEnumConstantInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
            }
            return psiEnumConstantInitializer;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiEnumConstantInitializer initializer = factory.createEnumConstantFromText("foo{}", null).getInitializingClass();
        LOG.assertTrue(initializer != null);
        PsiExpressionList argumentList = this.getArgumentList();
        if (argumentList != null) {
            PsiEnumConstantInitializer psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter((PsiElement)initializer, (PsiElement)argumentList);
            if (psiEnumConstantInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
            }
            return psiEnumConstantInitializer;
        }
        PsiEnumConstantInitializer psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter((PsiElement)initializer, (PsiElement)this.getNameIdentifier());
        if (psiEnumConstantInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
        }
        return psiEnumConstantInitializer;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "hasModifierProperty"));
        }
        return "public".equals(name) || "static".equals(name) || "final".equals(name);
    }

    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getContainingClass());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getType"));
        }
        return psiClassType;
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return true;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public Object computeConstantValue() {
        return this;
    }

    public PsiMethod resolveMethod() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), (PsiElement)this);
        return (PsiMethod)resolveResult.getElement();
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        JavaResolveResult javaResolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), (PsiElement)this);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.calcTreeElement().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "setName"));
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.calcTreeElement().findChildByRoleAsPsiElement(7);
    }

    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        PsiDocComment docComment = this.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null || this.getModifierList().findAnnotation("java.lang.Deprecated") != null;
    }

    @Override
    public PsiReference getReference() {
        return this.myReference;
    }

    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo((PsiField)this, another);
    }

    private class MyReference
    implements PsiJavaReference {
        private MyReference() {
        }

        public PsiElement getElement() {
            return PsiEnumConstantImpl.this;
        }

        public TextRange getRangeInElement() {
            PsiIdentifier nameIdentifier = PsiEnumConstantImpl.this.getNameIdentifier();
            int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + nameIdentifier.getTextLength());
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "bindToElement"));
            }
            throw new IncorrectOperationException("Invalid operation");
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public void processVariants(@NotNull PsiScopeProcessor processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "processVariants"));
            }
        }

        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)PsiEnumConstantImpl.this.getProject());
            PsiClassType type = facade.getElementFactory().createType(PsiEnumConstantImpl.this.getContainingClass());
            JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(type, PsiEnumConstantImpl.this.getArgumentList(), this.getElement());
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }

        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult[] results = this.multiResolve(incompleteCode);
            if (results.length == 1) {
                JavaResolveResult javaResolveResult = results[0];
                if (javaResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "advancedResolve"));
                }
                return javaResolveResult;
            }
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "advancedResolve"));
            }
            return javaResolveResult;
        }

        public PsiElement resolve() {
            return this.advancedResolve(false).getElement();
        }

        @NotNull
        public String getCanonicalText() {
            String string = PsiEnumConstantImpl.this.getContainingClass().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "getCanonicalText"));
            }
            return string;
        }

        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && ((PsiMethod)element).getContainingClass() == PsiEnumConstantImpl.this.getContainingClass() && PsiEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }
    }
}

