/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleManagerRunnable<T> {
    protected CodeStyleSettings mySettings;
    protected CommonCodeStyleSettings.IndentOptions myIndentOptions;
    protected FormattingModel myModel;
    protected TextRange mySignificantRange;
    private final CodeStyleManagerImpl myCodeStyleManager;
    @NotNull
    private final FormattingMode myMode;

    CodeStyleManagerRunnable(CodeStyleManagerImpl codeStyleManager, @NotNull FormattingMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable", "<init>"));
        }
        this.myCodeStyleManager = codeStyleManager;
        this.myMode = mode;
    }

    public T perform(PsiFile file, int offset, @Nullable TextRange range, T defaultValue) {
        FormattingModelBuilder elementBuilder;
        PsiFile templateFile;
        PsiDocumentManager documentManager;
        Document document;
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myCodeStyleManager.getProject())).getDocument(file)) instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document;
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
            if (!file.equals(topLevelFile)) {
                if (range != null) {
                    range = documentWindow.injectedToHost(range);
                }
                if (offset != -1) {
                    offset = documentWindow.injectedToHost(offset);
                }
                return this.adjustResultForInjected(this.perform(topLevelFile, offset, range, defaultValue), documentWindow);
            }
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file)) != null) {
            file = templateFile;
            document = documentManager.getDocument(templateFile);
        }
        PsiElement element = null;
        if (offset != -1) {
            element = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset);
            if (element == null && offset != file.getTextLength()) {
                return defaultValue;
            }
            if (CodeStyleManagerRunnable.isInsidePlainComment(offset, element)) {
                return this.computeValueInsidePlainComment(file, offset, defaultValue);
            }
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        FormattingModelBuilder formattingModelBuilder = elementBuilder = element != null ? LanguageFormatting.INSTANCE.forContext(element) : builder;
        if (builder != null && elementBuilder != null) {
            T result;
            this.mySettings = CodeStyleSettingsManager.getSettings((Project)this.myCodeStyleManager.getProject());
            this.mySignificantRange = offset != -1 ? CodeStyleManagerRunnable.getSignificantRange(file, offset) : null;
            this.myIndentOptions = this.mySettings.getIndentOptionsByFile(file, this.mySignificantRange);
            this.myModel = CoreFormatterUtil.buildModel(builder, (PsiElement)file, this.mySettings, this.myMode);
            if (document != null && this.useDocumentBaseFormattingModel()) {
                this.myModel = new DocumentBasedFormattingModel(this.myModel, document, this.myCodeStyleManager.getProject(), this.mySettings, file.getFileType(), file);
            }
            if ((result = this.doPerform(offset, range)) != null) {
                return result;
            }
        }
        return defaultValue;
    }

    protected boolean useDocumentBaseFormattingModel() {
        return true;
    }

    protected T adjustResultForInjected(T result, DocumentWindow documentWindow) {
        return result;
    }

    protected T computeValueInsidePlainComment(PsiFile file, int offset, T defaultValue) {
        return defaultValue;
    }

    @Nullable
    protected abstract T doPerform(int var1, TextRange var2);

    private static boolean isInsidePlainComment(int offset, @Nullable PsiElement element) {
        if (!(element instanceof PsiComment) || element instanceof PsiDocCommentBase || !element.getTextRange().contains(offset - 1)) {
            return false;
        }
        return !(element instanceof PsiLanguageInjectionHost) || !InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element);
    }

    private static TextRange getSignificantRange(PsiFile file, int offset) {
        ASTNode elementAtOffset = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset));
        if (elementAtOffset == null) {
            int significantRangeStart = CharArrayUtil.shiftBackward((CharSequence)file.getText(), (int)(offset - 1), (String)"\r\t ");
            return new TextRange(Math.max(significantRangeStart, 0), offset);
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        TextRange textRange = builder.getRangeAffectingIndent(file, offset, elementAtOffset);
        if (textRange != null) {
            return textRange;
        }
        return elementAtOffset.getTextRange();
    }
}

