/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.Nullable;

public class SpeedSearchComparator {
    private MinusculeMatcher myMinusculeMatcher;
    private String myRecentSearchText;
    private final boolean myShouldMatchFromTheBeginning;
    private final boolean myShouldMatchCamelCase;

    public SpeedSearchComparator() {
        this(true);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning) {
        this(shouldMatchFromTheBeginning, false);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning, boolean shouldMatchCamelCase) {
        this.myShouldMatchFromTheBeginning = shouldMatchFromTheBeginning;
        this.myShouldMatchCamelCase = shouldMatchCamelCase;
    }

    public int matchingDegree(String pattern, String text) {
        return this.obtainMatcher(pattern).matchingDegree(text);
    }

    @Nullable
    public Iterable<TextRange> matchingFragments(String pattern, String text) {
        return this.obtainMatcher(pattern).matchingFragments(text);
    }

    private MinusculeMatcher obtainMatcher(String pattern) {
        if (this.myRecentSearchText == null || !this.myRecentSearchText.equals(pattern)) {
            this.myRecentSearchText = pattern;
            if (this.myShouldMatchCamelCase) {
                pattern = StringUtil.join((String[])NameUtil.nameToWords((String)pattern), (String)"*");
            }
            if (!this.myShouldMatchFromTheBeginning && !pattern.startsWith("*")) {
                pattern = "*" + pattern;
            }
            this.myMinusculeMatcher = new MinusculeMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
        }
        return this.myMinusculeMatcher;
    }

    public String getRecentSearchText() {
        return this.myRecentSearchText;
    }
}

