/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;

public final class BuiltInWebServer
extends HttpRequestHandler {
    static final Logger LOG = Logger.getInstance(BuiltInWebServer.class);

    @Nullable
    public static VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        if (basedir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basedir", "org/jetbrains/builtInWebServer/BuiltInWebServer", "findIndexFile"));
        }
        VirtualFile[] children = basedir.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        for (String indexNamePrefix : new String[]{"index.", "default."}) {
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (VirtualFile child : children) {
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (name.equals(preferredName)) {
                    return child;
                }
                if (index != null || !name.startsWith(indexNamePrefix)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    @Override
    public boolean isAccessible(@NotNull HttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer", "isAccessible"));
        }
        return NettyUtil.isLocalOrigin(request, false, true);
    }

    @Override
    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer", "isSupported"));
        }
        return super.isSupported(request) || request.method() == HttpMethod.POST;
    }

    @Override
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String projectName;
        boolean isIpv6;
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/builtInWebServer/BuiltInWebServer", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/builtInWebServer/BuiltInWebServer", "process"));
        }
        String host = request.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (StringUtil.isEmpty((String)host)) {
            return false;
        }
        int portIndex = host.indexOf(58);
        if (portIndex > 0) {
            host = host.substring(0, portIndex);
        }
        boolean bl = isIpv6 = host.charAt(0) == '[' && host.length() > 2 && host.charAt(host.length() - 1) == ']';
        if (isIpv6) {
            host = host.substring(1, host.length() - 1);
        }
        if (isIpv6 || Character.digit(host.charAt(0), 10) != -1 || host.charAt(0) == ':' || BuiltInWebServer.isOwnHostName(host)) {
            if (urlDecoder.path().length() < 2) {
                return false;
            }
            projectName = null;
        } else {
            projectName = host;
        }
        return BuiltInWebServer.doProcess(request, context, projectName);
    }

    public static boolean isOwnHostName(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/builtInWebServer/BuiltInWebServer", "isOwnHostName"));
        }
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (host.equals(address.getHostAddress()) || host.equalsIgnoreCase(address.getCanonicalHostName())) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return localHostName.equalsIgnoreCase(host) || host.endsWith(".local") && localHostName.regionMatches(true, 0, host, 0, host.length() - ".local".length());
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static boolean doProcess(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectName) {
        boolean emptyPath;
        int offset;
        boolean isCustomHost;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer", "doProcess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/builtInWebServer/BuiltInWebServer", "doProcess"));
        }
        String decodedPath = URLUtil.unescapePercentSequences((String)UriUtil.trimParameters(request.uri()));
        boolean bl = isCustomHost = projectName != null;
        if (isCustomHost) {
            offset = 0;
            emptyPath = decodedPath.isEmpty();
        } else {
            offset = decodedPath.indexOf(47, 1);
            projectName = decodedPath.substring(1, offset == -1 ? decodedPath.length() : offset);
            emptyPath = offset == -1;
        }
        Project project = BuiltInWebServer.findProject(projectName, isCustomHost);
        if (project == null) {
            return false;
        }
        if (emptyPath) {
            if (!SystemInfoRt.isFileSystemCaseSensitive) {
                projectName = project.getName();
            }
            WebServerPathHandler.redirectToDirectory((HttpRequest)request, context.channel(), projectName);
            return true;
        }
        String path = BuiltInWebServer.toIdeaPath(decodedPath, offset);
        if (path == null) {
            LOG.warn(decodedPath + " is not valid");
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)request);
            return true;
        }
        for (WebServerPathHandler pathHandler : (WebServerPathHandler[])WebServerPathHandler.EP_NAME.getExtensions()) {
            try {
                if (!pathHandler.process(path, project, request, context, projectName, decodedPath, isCustomHost)) continue;
                return true;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return false;
    }

    static boolean canBeAccessedDirectly(String path) {
        for (WebServerFileHandler fileHandler : (WebServerFileHandler[])WebServerFileHandler.EP_NAME.getExtensions()) {
            for (String ext : fileHandler.pageFileExtensions()) {
                if (!FileUtilRt.extensionEquals((String)path, (String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    private static String toIdeaPath(String decodedPath, int offset) {
        String path = decodedPath.substring(offset);
        if (!path.startsWith("/")) {
            return null;
        }
        return FileUtil.toCanonicalPath((String)path, (char)'/').substring(1);
    }

    @Nullable
    private static Project findProject(String projectName, boolean isCustomHost) {
        Project candidateByDirectoryName = null;
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            String name = project.getName();
            if (!project.isDisposed() && (isCustomHost || !SystemInfoRt.isFileSystemCaseSensitive ? projectName.equalsIgnoreCase(name) : projectName.equals(name))) {
                return project;
            }
            if (candidateByDirectoryName != null || !BuiltInWebServer.compareNameAndProjectBasePath(projectName, project)) continue;
            candidateByDirectoryName = project;
        }
        return candidateByDirectoryName;
    }

    public static boolean compareNameAndProjectBasePath(String projectName, Project project) {
        String basePath = project.getBasePath();
        return basePath != null && basePath.length() > projectName.length() && basePath.endsWith(projectName) && basePath.charAt(basePath.length() - projectName.length() - 1) == '/';
    }

    static final class StaticFileHandler
    extends WebServerFileHandler {
        private SsiProcessor ssiProcessor;
        private static List<String> ourPageFileExtensions = ContainerUtil.list((Object[])new String[]{"html", "htm", "shtml", "stm", "shtm"});

        StaticFileHandler() {
        }

        @Override
        protected List<String> pageFileExtensions() {
            return ourPageFileExtensions;
        }

        @Override
        public boolean process(@NotNull VirtualFile file, @NotNull CharSequence canonicalRequestPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, boolean isCustomHost) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "process"));
            }
            if (canonicalRequestPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalRequestPath", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "process"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "process"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "process"));
            }
            if (channel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "process"));
            }
            if (file.isInLocalFileSystem()) {
                CharSequence nameSequence = file.getNameSequence();
                if (StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm")) {
                    this.processSsi(file, canonicalRequestPath, project, request, channel, isCustomHost);
                    return true;
                }
                FileResponses.sendFile((HttpRequest)request, channel, VfsUtilCore.virtualToIoFile((VirtualFile)file));
            } else {
                HttpResponse response = FileResponses.prepareSend((HttpRequest)request, channel, file.getTimeStamp(), file.getPath());
                if (response == null) {
                    return true;
                }
                boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
                if (request.method() != HttpMethod.HEAD) {
                    HttpHeaderUtil.setContentLength((HttpMessage)response, (long)file.getLength());
                }
                channel.write((Object)response);
                if (request.method() != HttpMethod.HEAD) {
                    channel.write((Object)new ChunkedStream(file.getInputStream()));
                }
                ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                if (!keepAlive) {
                    future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSsi(@NotNull VirtualFile file, @NotNull CharSequence canonicalRequestPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, boolean isCustomHost) throws IOException {
            boolean keepAlive;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "processSsi"));
            }
            if (canonicalRequestPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalRequestPath", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "processSsi"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "processSsi"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "processSsi"));
            }
            if (channel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/builtInWebServer/BuiltInWebServer$StaticFileHandler", "processSsi"));
            }
            String path = PathUtilRt.getParentPath((String)((Object)canonicalRequestPath).toString());
            if (!isCustomHost) {
                path = path.substring(path.indexOf(47, 1) + 1);
            }
            if (this.ssiProcessor == null) {
                this.ssiProcessor = new SsiProcessor(false);
            }
            ByteBuf buffer = channel.alloc().ioBuffer();
            boolean releaseBuffer = true;
            try {
                long lastModified = this.ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file.getParent()), VfsUtilCore.loadText((VirtualFile)file), file.getTimeStamp(), new ByteBufUtf8Writer(buffer));
                HttpResponse response = FileResponses.prepareSend((HttpRequest)request, channel, lastModified, file.getPath());
                if (response == null) {
                    return;
                }
                keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
                if (request.method() != HttpMethod.HEAD) {
                    HttpHeaderUtil.setContentLength((HttpMessage)response, (long)buffer.readableBytes());
                }
                channel.write((Object)response);
                if (request.method() != HttpMethod.HEAD) {
                    releaseBuffer = false;
                    channel.write((Object)buffer);
                }
            }
            finally {
                if (releaseBuffer) {
                    buffer.release();
                }
            }
            ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!keepAlive) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        static boolean checkAccess(Channel channel, File file, HttpRequest request, File root) {
            File parent = file;
            do {
                if (StaticFileHandler.hasAccess(parent)) continue;
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
                return false;
            } while ((parent = parent.getParentFile()) != null && !FileUtil.filesEqual((File)parent, (File)root));
            return true;
        }

        private static boolean hasAccess(File result) {
            return result.canRead() && !result.isHidden() && !result.getName().startsWith(".");
        }
    }
}

