/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import io.netty.bootstrap.Bootstrap;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.rpc.CommandProcessor;

public abstract class RemoteVmConnection
extends VmConnection<Vm> {
    private final AtomicReference<Runnable> connectCancelHandler = new AtomicReference();

    @Override
    @Nullable
    public WebBrowser getBrowser() {
        return null;
    }

    @NotNull
    public abstract Bootstrap createBootstrap(@NotNull InetSocketAddress var1, @NotNull AsyncPromise<Vm> var2);

    public void open(@NotNull InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "org/jetbrains/debugger/connection/RemoteVmConnection", "open"));
        }
        this.open(address, null);
    }

    public void open(final @NotNull InetSocketAddress address, final Condition<Void> stopCondition) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "org/jetbrains/debugger/connection/RemoteVmConnection", "open"));
        }
        this.setState(ConnectionStatus.WAITING_FOR_CONNECTION, "Connecting to " + address.getHostName() + ":" + address.getPort());
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (Thread.interrupted()) {
                    return;
                }
                final AsyncPromise result = new AsyncPromise();
                RemoteVmConnection.this.connectCancelHandler.set(new Runnable(){

                    @Override
                    public void run() {
                        result.setError((Throwable)Promise.createError((String)"Closed explicitly"));
                    }
                });
                AsyncPromise connectionPromise = new AsyncPromise();
                NettyUtil.connect(RemoteVmConnection.this.createBootstrap(address, (AsyncPromise<Vm>)result), address, connectionPromise, stopCondition == null ? 20 : -1, (Condition<Void>)stopCondition);
                connectionPromise.rejected((Consumer)new Consumer<Throwable>(){

                    public void consume(Throwable error) {
                        result.setError(error);
                    }
                });
                result.done((Consumer)new Consumer<Vm>(){

                    public void consume(@NotNull Vm vm) {
                        if (vm == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/connection/RemoteVmConnection$1$5", "consume"));
                        }
                        RemoteVmConnection.this.vm = vm;
                        RemoteVmConnection.this.setState(ConnectionStatus.CONNECTED, "Connected to " + RemoteVmConnection.this.connectedAddressToPresentation(address, vm));
                        RemoteVmConnection.this.startProcessing();
                    }
                }).rejected((Consumer)new Consumer<Throwable>(){

                    public void consume(Throwable error) {
                        if (ApplicationManager.getApplication().isUnitTestMode() || !(error instanceof Promise.MessageError)) {
                            CommandProcessor.LOG.error(error);
                        }
                        RemoteVmConnection.this.setState(ConnectionStatus.CONNECTION_FAILED, error.getMessage());
                    }
                }).processed((Consumer)new Consumer<Vm>(){

                    public void consume(Vm vm) {
                        RemoteVmConnection.this.connectCancelHandler.set(null);
                    }
                });
            }
        });
        this.connectCancelHandler.set(new Runnable(){

            @Override
            public void run() {
                future.cancel(true);
            }
        });
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "org/jetbrains/debugger/connection/RemoteVmConnection", "connectedAddressToPresentation"));
        }
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/connection/RemoteVmConnection", "connectedAddressToPresentation"));
        }
        String string = address.getHostName() + ":" + address.getPort();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/RemoteVmConnection", "connectedAddressToPresentation"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Promise<Void> detachAndClose() {
        Promise<Void> callback;
        try {
            Runnable runnable = this.connectCancelHandler.getAndSet(null);
            if (runnable != null) {
                runnable.run();
            }
        }
        finally {
            callback = super.detachAndClose();
        }
        Promise<Void> promise = callback;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/RemoteVmConnection", "detachAndClose"));
        }
        return promise;
    }

    @NotNull
    public static <T> Promise<T> chooseDebuggee(final @NotNull Collection<T> targets, final int selectedIndex, final @NotNull Function<T, String> itemToString) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "org/jetbrains/debugger/connection/RemoteVmConnection", "chooseDebuggee"));
        }
        if (itemToString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemToString", "org/jetbrains/debugger/connection/RemoteVmConnection", "chooseDebuggee"));
        }
        if (targets.size() == 1) {
            Promise promise = Promise.resolve((Object)ContainerUtil.getFirstItem(targets));
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/RemoteVmConnection", "chooseDebuggee"));
            }
            return promise;
        }
        if (targets.isEmpty()) {
            Promise promise = Promise.reject((String)"No tabs to inspect");
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/RemoteVmConnection", "chooseDebuggee"));
            }
            return promise;
        }
        final AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final JBList list = new JBList(targets);
                list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        this.append((String)itemToString.fun(value));
                    }
                });
                if (selectedIndex != -1) {
                    list.setSelectedIndex(selectedIndex);
                }
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Page to Debug").setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        Object value = list.getSelectedValue();
                        if (value == null) {
                            result.setError((Throwable)Promise.createError((String)"No target to inspect"));
                        } else {
                            result.setResult(value);
                        }
                    }
                }).createPopup().showInFocusCenter();
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/RemoteVmConnection", "chooseDebuggee"));
        }
        return asyncPromise;
    }
}

