/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;

public class HardcodedDebugModeDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ISSUE = Issue.create("HardcodedDebugMode", "Hardcoded value of `android:debuggable` in the manifest", "It's best to leave out the `android:debuggable` attribute from the manifest. If you do, then the tools will automatically insert `android:debuggable=true` when building an APK to debug on an emulator or device. And when you perform a release build, such as Exporting APK, it will automatically set it to `false`.\n\nIf on the other hand you specify a specific value in the manifest file, then the tools will always use it. This can lead to accidentally publishing your app with debug information.", Category.SECURITY, 5, Severity.FATAL, new Implementation(HardcodedDebugModeDetector.class, Scope.MANIFEST_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singleton("debuggable");
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        if (attribute.getNamespaceURI().equals("http://schemas.android.com/apk/res/android")) {
            context.report(ISSUE, attribute, context.getLocation(attribute), "Avoid hardcoding the debug mode; leaving it out allows debug and release builds to automatically assign one");
        }
    }
}

