/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import git4idea.push.GitPushNativeResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushNativeResultParser {
    private static final Logger LOG = Logger.getInstance(GitPushNativeResultParser.class);
    private static final Pattern PATTERN = Pattern.compile("^.*([ +\\-\\*!=])\\s(\\S+):(\\S+)\\s(\\S+).*$");
    private static final Pattern RANGE = Pattern.compile("[0-9a-f]+[\\.]{2,3}[0-9a-f]+");

    @NotNull
    public static List<GitPushNativeResult> parse(@NotNull List<String> output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/push/GitPushNativeResultParser", "parse"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (String line : output) {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            results.add(GitPushNativeResultParser.parseRefResult(matcher, line));
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushNativeResultParser", "parse"));
        }
        return arrayList;
    }

    @Nullable
    private static GitPushNativeResult parseRefResult(Matcher matcher, String line) {
        String flag = matcher.group(1);
        String from = matcher.group(2);
        String to = matcher.group(3);
        String summary = matcher.group(4);
        GitPushNativeResult.Type type = GitPushNativeResultParser.parseType(flag);
        if (type == null) {
            LOG.error("Couldn't parse push result type from flag [" + flag + "] in [" + line + "]");
            return null;
        }
        if (matcher.groupCount() < 4) {
            return null;
        }
        String range = RANGE.matcher(summary).matches() ? summary : null;
        return new GitPushNativeResult(type, from, range);
    }

    private static GitPushNativeResult.Type parseType(String flag) {
        switch (flag.charAt(0)) {
            case ' ': {
                return GitPushNativeResult.Type.SUCCESS;
            }
            case '+': {
                return GitPushNativeResult.Type.FORCED_UPDATE;
            }
            case '-': {
                return GitPushNativeResult.Type.DELETED;
            }
            case '*': {
                return GitPushNativeResult.Type.NEW_REF;
            }
            case '!': {
                return GitPushNativeResult.Type.REJECTED;
            }
            case '=': {
                return GitPushNativeResult.Type.UP_TO_DATE;
            }
        }
        return null;
    }
}

