/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.messaging.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuingDispatch<T>
implements Dispatch<T>,
Stoppable {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private List<T> queue = new ArrayList<T>();
    private Dispatch<? super T> dispatch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchTo(Dispatch<? super T> dispatch) {
        this.lock.lock();
        try {
            this.dispatch = dispatch;
            for (T message : this.queue) {
                dispatch.dispatch(message);
            }
            this.queue = null;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T message) {
        this.lock.lock();
        try {
            if (this.dispatch == null) {
                this.queue.add(message);
            } else {
                this.dispatch.dispatch(message);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        this.lock.lock();
        try {
            while (this.queue != null && !this.queue.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

