/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.StatisticsTable;
import com.intellij.execution.junit2.ui.TestColumnInfo;
import com.intellij.execution.junit2.ui.TestTableRenderer;
import com.intellij.execution.junit2.ui.actions.TestContext;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.TableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.config.Storage;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class StatisticsPanel
extends JPanel
implements DataProvider {
    private final MyJUnitListener myListener = new MyJUnitListener();
    private TestProxy myCurrentTest = null;
    private StatisticsTable myChildInfo = null;
    private JUnitRunningModel myModel;
    private final TableView myTable;
    private final Storage.PropertiesComponentStorage myStorage = new Storage.PropertiesComponentStorage("junit_statistics_table_columns");
    private SimpleColoredComponent myTotalLabel;
    private SimpleColoredComponent myTimeLabel;

    public StatisticsPanel() {
        super(new BorderLayout(0, 0));
        this.myChildInfo = new StatisticsTable(TestColumnInfo.COLUMN_NAMES);
        this.myTable = new TableView(this.myChildInfo){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new TestTableRenderer(TestColumnInfo.COLUMN_NAMES);
            }
        };
        EditSourceOnDoubleClickHandler.install((JTable)this.myTable);
        PopupHandler.installPopupHandler((JComponent)this.myTable, (String)"TestStatisticsTablePopupMenu", (String)"TestStatisticsViewPopup");
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable), "Center");
        JPanel eastPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myTotalLabel = new SimpleColoredComponent();
        eastPanel.add((Component)this.myTotalLabel);
        this.myTimeLabel = new SimpleColoredComponent();
        eastPanel.add((Component)this.myTimeLabel);
        this.add((Component)eastPanel, "South");
    }

    private void updateStatistics() {
        TestProxy proxy;
        this.myTable.setVisible(true);
        TestProxy testProxy = proxy = this.myCurrentTest != null ? this.myCurrentTest : this.myModel.getRoot();
        if (proxy.isLeaf() && proxy.getParent() != null) {
            proxy = proxy.getParent();
        }
        this.myChildInfo.updateStatistics(proxy);
        this.myTotalLabel.clear();
        this.myTotalLabel.append(TestsUIUtil.getTestSummary((AbstractTestProxy)proxy), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myTimeLabel.clear();
        this.myTimeLabel.append("Total time: " + Formatters.statisticsFor(proxy).getTime(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        int idx = this.myChildInfo.getIndexOf((Object)this.myCurrentTest);
        if (idx >= 0) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{this.myTable.convertRowIndexToView(idx)});
        }
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    public void attachTo(JUnitRunningModel model) {
        this.myModel = model;
        this.myModel.addListener(this.myListener);
        this.myChildInfo.setModel(model);
        BaseTableView.restore((Storage)this.myStorage, (JTable)this.myTable);
    }

    public Object getData(String dataId) {
        TestProxy selectedTest;
        if (this.myModel == null) {
            return null;
        }
        int selectedRow = this.myTable.getSelectedRow();
        TestProxy testProxy = selectedTest = selectedRow == -1 ? null : this.myChildInfo.getTestAt(this.myTable.convertRowIndexToModel(selectedRow));
        if (TestContext.DATA_KEY.is(dataId)) {
            return new TestContext(this.myModel, selectedTest);
        }
        return TestsUIUtil.getData((AbstractTestProxy)selectedTest, (String)dataId, (TestFrameworkRunningModel)this.myModel);
    }

    private class MyJUnitListener
    extends JUnitAdapter {
        private MyJUnitListener() {
        }

        @Override
        public void onTestChanged(TestEvent event) {
            if (!StatisticsPanel.this.isShowing()) {
                return;
            }
            TestProxy source = event.getSource();
            if (StatisticsPanel.this.myCurrentTest == source || StatisticsPanel.this.myCurrentTest == null && source == StatisticsPanel.this.myModel.getRoot()) {
                StatisticsPanel.this.updateStatistics();
            }
        }

        @Override
        public void onTestSelected(TestProxy test) {
            if (!StatisticsPanel.this.isShowing()) {
                return;
            }
            if (StatisticsPanel.this.myCurrentTest == test) {
                return;
            }
            if (test == null) {
                StatisticsPanel.this.myTable.setVisible(false);
                return;
            }
            StatisticsPanel.this.myCurrentTest = test;
            StatisticsPanel.this.updateStatistics();
        }

        @Override
        public void doDispose() {
            BaseTableView.store((Storage)StatisticsPanel.this.myStorage, (JTable)StatisticsPanel.this.myTable);
            StatisticsPanel.this.myTable.setModelAndUpdateColumns(new ListTableModel(TestColumnInfo.COLUMN_NAMES));
            StatisticsPanel.this.myModel = null;
            StatisticsPanel.this.myChildInfo = null;
            StatisticsPanel.this.myCurrentTest = null;
        }
    }
}

