/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.xml.sax.Attributes;

public class DAVErrorHandler
extends BasicDAVHandler {
    private static final DAVElement SVN_ERROR = DAVElement.getElement("svn:", "error");
    private static final DAVElement ERROR_DATA = DAVElement.getElement("http://apache.org/dav/xmlns", "human-readable");
    private SVNErrorMessage myError;
    private SVNErrorCode myErrorCode;
    private String myErrorMessage;

    public DAVErrorHandler() {
        this.init();
        this.myErrorCode = SVNErrorCode.RA_DAV_REQUEST_FAILED;
        this.myErrorMessage = "General svn error from server";
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myError;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        String errCode;
        if (element == SVN_ERROR) {
            this.myErrorMessage = "General svn error from server";
            this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
        } else if (element == ERROR_DATA && (errCode = attrs.getValue("errcode")) != null) {
            try {
                this.myErrorCode = SVNErrorCode.getErrorCode(Integer.parseInt(errCode));
                this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == ERROR_DATA && cdata != null) {
            String errorMessage = cdata.toString();
            while (errorMessage.endsWith("\n")) {
                errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
            }
            while (errorMessage.startsWith("\n")) {
                errorMessage = errorMessage.substring(1);
            }
            this.myErrorMessage = errorMessage;
            this.myError = SVNErrorMessage.create(this.myErrorCode, this.myErrorMessage);
        }
    }
}

