/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;

public class HgResolveCommand {
    private static final int ITEM_COUNT = 3;
    private final Project myProject;

    public HgResolveCommand(Project project) {
        this.myProject = project;
    }

    public Map<HgFile, HgResolveStatusEnum> getListSynchronously(VirtualFile repo) {
        if (repo == null) {
            return Collections.emptyMap();
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        HgCommandResult result = executor.executeInCurrentThread(repo, "resolve", Arrays.asList("--list"));
        if (result == null) {
            return Collections.emptyMap();
        }
        return HgResolveCommand.handleResult(repo, result);
    }

    public void list(final VirtualFile repo, final Consumer<Map<HgFile, HgResolveStatusEnum>> resultHandler) {
        if (repo == null) {
            resultHandler.consume(Collections.emptyMap());
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        executor.execute(repo, "resolve", Arrays.asList("--list"), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (result == null) {
                    resultHandler.consume(Collections.emptyMap());
                }
                Map resolveStatus = HgResolveCommand.handleResult(repo, result);
                resultHandler.consume((Object)resolveStatus);
            }
        });
    }

    private static Map<HgFile, HgResolveStatusEnum> handleResult(VirtualFile repo, HgCommandResult result) {
        HashMap<HgFile, HgResolveStatusEnum> resolveStatus = new HashMap<HgFile, HgResolveStatusEnum>();
        for (String line : result.getOutputLines()) {
            HgResolveStatusEnum status;
            if (StringUtil.isEmptyOrSpaces((String)line) || line.length() < 3 || (status = HgResolveStatusEnum.valueOf(line.charAt(0))) == null) continue;
            File ioFile = new File(repo.getPath(), line.substring(2));
            resolveStatus.put(new HgFile(repo, ioFile), status);
        }
        return resolveStatus;
    }

    public void markResolved(VirtualFile repo, VirtualFile path) {
        new HgCommandExecutor(this.myProject).execute(repo, "resolve", Arrays.asList("--mark", path.getPath()), null);
    }

    public void markResolved(VirtualFile repo, Collection<FilePath> paths) {
        for (List chunk : VcsFileUtil.chunkPaths((VirtualFile)repo, paths)) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--mark");
            args.addAll(chunk);
            new HgCommandExecutor(this.myProject).execute(repo, "resolve", args, null);
        }
    }
}

