/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRepository
extends TaskRepository {
    private static final Pattern PATTERN = Pattern.compile("[A-Z]+\\-\\d+");
    protected String myUsername = "";
    protected String myPassword = "";
    protected boolean myUseProxy;
    protected boolean myUseHttpAuthentication;
    protected boolean myLoginAnonymously;
    protected CustomTaskState myPreferredOpenTaskState;
    private CustomTaskState myPreferredCloseTaskState;

    public BaseRepository(TaskRepositoryType type) {
        super(type);
    }

    public BaseRepository(BaseRepository other) {
        super(other);
        this.myPassword = other.getPassword();
        this.myUsername = other.getUsername();
        this.myUseProxy = other.myUseProxy;
        this.myUseHttpAuthentication = other.myUseHttpAuthentication;
        this.myLoginAnonymously = other.myLoginAnonymously;
    }

    public BaseRepository() {
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    @Tag(value="username")
    public String getUsername() {
        return this.myUsername;
    }

    @Transient
    public String getPassword() {
        return this.myPassword;
    }

    @Tag(value="password")
    public String getEncodedPassword() {
        return PasswordUtil.encodePassword((String)this.getPassword());
    }

    public void setEncodedPassword(String password) {
        try {
            this.setPassword(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public abstract BaseRepository clone();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRepository)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseRepository that = (BaseRepository)o;
        if (!Comparing.equal((String)this.getUrl(), (String)that.getUrl())) {
            return false;
        }
        if (!Comparing.equal((String)this.getPassword(), (String)that.getPassword())) {
            return false;
        }
        if (!Comparing.equal((String)this.getUsername(), (String)that.getUsername())) {
            return false;
        }
        if (!Comparing.equal((Object)this.isLoginAnonymously(), (Object)that.isLoginAnonymously())) {
            return false;
        }
        if (!Comparing.equal((Object)this.isUseProxy(), (Object)that.isUseProxy())) {
            return false;
        }
        return Comparing.equal((Object)this.isUseHttpAuthentication(), (Object)that.isUseHttpAuthentication());
    }

    public boolean isUseProxy() {
        return this.myUseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.myUseProxy = useProxy;
    }

    public boolean isUseHttpAuthentication() {
        return this.myUseHttpAuthentication;
    }

    public void setUseHttpAuthentication(boolean useHttpAuthentication) {
        this.myUseHttpAuthentication = useHttpAuthentication;
    }

    public boolean isLoginAnonymously() {
        return this.myLoginAnonymously;
    }

    public void setLoginAnonymously(boolean loginAnonymously) {
        this.myLoginAnonymously = loginAnonymously;
    }

    @Override
    public void setPreferredOpenTaskState(@Nullable CustomTaskState state) {
        this.myPreferredOpenTaskState = state;
    }

    @Override
    @Nullable
    public CustomTaskState getPreferredOpenTaskState() {
        return this.myPreferredOpenTaskState;
    }

    @Override
    public void setPreferredCloseTaskState(@Nullable CustomTaskState state) {
        this.myPreferredCloseTaskState = state;
    }

    @Override
    @Nullable
    public CustomTaskState getPreferredCloseTaskState() {
        return this.myPreferredCloseTaskState;
    }

    @Override
    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/tasks/impl/BaseRepository", "extractId"));
        }
        Matcher matcher = PATTERN.matcher(taskName);
        return matcher.find() ? matcher.group() : null;
    }

    @Override
    public void setUrl(String url) {
        super.setUrl(BaseRepository.addSchemeIfNoneSpecified(url));
    }

    @Nullable
    private static String addSchemeIfNoneSpecified(@Nullable String url) {
        if (StringUtil.isNotEmpty((String)url)) {
            try {
                String scheme = new URI(url).getScheme();
                if (scheme == null || !scheme.startsWith("http")) {
                    url = "http://" + url;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return url;
    }
}

