/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @Nullable Module module, @NotNull PsiFile file) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/xml/XmlSchemaProvider", "findSchema"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlSchemaProvider", "findSchema"));
        }
        if (file.getProject().isDefault()) {
            return null;
        }
        boolean dumb = DumbService.getInstance(file.getProject()).isDumb();
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            XmlFile schema;
            if (dumb && !DumbService.isDumbAware(provider) || file instanceof XmlFile && !provider.isAvailable((XmlFile)file) || (schema = provider.getSchema(namespace, module, file)) == null) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @NotNull PsiFile baseFile) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/xml/XmlSchemaProvider", "findSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/xml/XmlSchemaProvider", "findSchema"));
        }
        PsiDirectory directory = baseFile.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement(directory == null ? baseFile : directory);
        return XmlSchemaProvider.findSchema(namespace, module, baseFile);
    }

    @Deprecated
    @Nullable
    public static XmlSchemaProvider getAvailableProvider(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlSchemaProvider", "getAvailableProvider"));
        }
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isAvailable(file)) continue;
            return provider;
        }
        return null;
    }

    public static List<XmlSchemaProvider> getAvailableProviders(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlSchemaProvider", "getAvailableProviders"));
        }
        return ContainerUtil.findAll((Object[])Extensions.getExtensions(EP_NAME), (Condition)new Condition<XmlSchemaProvider>(){

            public boolean value(XmlSchemaProvider xmlSchemaProvider) {
                return xmlSchemaProvider.isAvailable(file);
            }
        });
    }

    @Nullable
    public abstract XmlFile getSchema(@NotNull @NonNls String var1, @Nullable Module var2, @NotNull PsiFile var3);

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlSchemaProvider", "isAvailable"));
        }
        return false;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlSchemaProvider", "getAvailableNamespaces"));
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/XmlSchemaProvider", "getAvailableNamespaces"));
        }
        return set;
    }

    @Nullable
    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/xml/XmlSchemaProvider", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/XmlSchemaProvider", "getDefaultPrefix"));
        }
        return null;
    }

    @Nullable
    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/xml/XmlSchemaProvider", "getLocations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/XmlSchemaProvider", "getLocations"));
        }
        return null;
    }
}

