/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.ecj;

import lombok.ast.ecj.EcjTreePrinter;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CombinedBinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

public class EcjTreeOperations {
    private EcjTreeOperations() {
    }

    private static String convertToString0(ASTNode tree, EcjTreePrinter printer) {
        EcjTreeOperations.dodgePostFixArraysInVarDeclarations(printer);
        EcjTreeOperations.dodgeCombinedBinaryExpressions(printer);
        EcjTreeOperations.dodgeExtendedStringLiterals(printer);
        printer.visit(tree);
        String string = printer.getContent();
        return string;
    }

    public static String convertToString(ASTNode tree) {
        return EcjTreeOperations.convertToString0(tree, EcjTreePrinter.printerWithPositions());
    }

    public static String convertToStringNoPositions(ASTNode tree) {
        return EcjTreeOperations.convertToString0(tree, EcjTreePrinter.printerWithoutPositions());
    }

    private static void dodgePostFixArraysInVarDeclarations(EcjTreePrinter printer) {
        printer.skipReferenceTracking(LocalDeclaration.class, TypeReference.class);
        printer.skipReferenceTracking(FieldDeclaration.class, TypeReference.class);
    }

    private static void dodgeExtendedStringLiterals(EcjTreePrinter printer) {
        printer.skipProperty(StringLiteral.class, "lineNumber");
        printer.skipPropertyIfHasValue(ExtendedStringLiteral.class, "lineNumber", -1);
        printer.skipPropertyIfHasValue(ExtendedStringLiteral.class, "lineNumber", -2);
        printer.skipPropertyIfHasValue(StringLiteral.class, "lineNumber", -1);
        printer.skipPropertyIfHasValue(StringLiteral.class, "lineNumber", -2);
        printer.stringReplace("ExtendedStringLiteral", "StringLiteral");
    }

    private static void dodgeCombinedBinaryExpressions(EcjTreePrinter printer) {
        printer.skipProperty(CombinedBinaryExpression.class, "arity");
        printer.skipProperty(CombinedBinaryExpression.class, "arityMax");
        printer.skipProperty(CombinedBinaryExpression.class, "referencesTable");
        printer.stringReplace("CombinedBinaryExpression", "BinaryExpression");
    }
}

