/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructContext;

public class DecompilerContext {
    public static final String CURRENT_CLASS = "CURRENT_CLASS";
    public static final String CURRENT_CLASS_WRAPPER = "CURRENT_CLASS_WRAPPER";
    public static final String CURRENT_CLASS_NODE = "CURRENT_CLASS_NODE";
    public static final String CURRENT_METHOD = "CURRENT_METHOD";
    public static final String CURRENT_METHOD_DESCRIPTOR = "CURRENT_METHOD_DESCRIPTOR";
    public static final String CURRENT_METHOD_WRAPPER = "CURRENT_METHOD_WRAPPER";
    public static final String CURRENT_VAR_PROCESSOR = "CURRENT_VAR_PROCESSOR";
    private static ThreadLocal<DecompilerContext> currentContext = new ThreadLocal();
    private final Map<String, Object> properties;
    private StructContext structContext;
    private ImportCollector importCollector;
    private VarNamesCollector varNamescollector;
    private CounterContainer counterContainer;
    private ClassesProcessor classProcessor;
    private PoolInterceptor poolInterceptor;
    private IFernflowerLogger logger;
    private BytecodeSourceMapper bytecodeSourceMapper;

    private DecompilerContext(Map<String, Object> properties) {
        this.properties = properties;
    }

    public static void initContext(Map<String, Object> propertiesCustom) {
        HashMap<String, Object> properties = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        if (propertiesCustom != null) {
            properties.putAll(propertiesCustom);
        }
        currentContext.set(new DecompilerContext(properties));
    }

    public static DecompilerContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(DecompilerContext context) {
        currentContext.set(context);
    }

    public static Object getProperty(String key) {
        return DecompilerContext.getCurrentContext().properties.get(key);
    }

    public static void setProperty(String key, Object value) {
        DecompilerContext.getCurrentContext().properties.put(key, value);
    }

    public static boolean getOption(String key) {
        return "1".equals(DecompilerContext.getCurrentContext().properties.get(key));
    }

    public static ImportCollector getImportCollector() {
        return DecompilerContext.getCurrentContext().importCollector;
    }

    public static void setImportCollector(ImportCollector importCollector) {
        DecompilerContext.getCurrentContext().importCollector = importCollector;
    }

    public static VarNamesCollector getVarNamesCollector() {
        return DecompilerContext.getCurrentContext().varNamescollector;
    }

    public static void setVarNamesCollector(VarNamesCollector varNamesCollector) {
        DecompilerContext.getCurrentContext().varNamescollector = varNamesCollector;
    }

    public static StructContext getStructContext() {
        return DecompilerContext.getCurrentContext().structContext;
    }

    public static void setStructContext(StructContext structContext) {
        DecompilerContext.getCurrentContext().structContext = structContext;
    }

    public static CounterContainer getCounterContainer() {
        return DecompilerContext.getCurrentContext().counterContainer;
    }

    public static void setCounterContainer(CounterContainer counterContainer) {
        DecompilerContext.getCurrentContext().counterContainer = counterContainer;
    }

    public static ClassesProcessor getClassProcessor() {
        return DecompilerContext.getCurrentContext().classProcessor;
    }

    public static void setClassProcessor(ClassesProcessor classProcessor) {
        DecompilerContext.getCurrentContext().classProcessor = classProcessor;
    }

    public static PoolInterceptor getPoolInterceptor() {
        return DecompilerContext.getCurrentContext().poolInterceptor;
    }

    public static void setPoolInterceptor(PoolInterceptor poolinterceptor) {
        DecompilerContext.getCurrentContext().poolInterceptor = poolinterceptor;
    }

    public static BytecodeSourceMapper getBytecodeSourceMapper() {
        return DecompilerContext.getCurrentContext().bytecodeSourceMapper;
    }

    public static void setBytecodeSourceMapper(BytecodeSourceMapper bytecodeSourceMapper) {
        DecompilerContext.getCurrentContext().bytecodeSourceMapper = bytecodeSourceMapper;
    }

    public static IFernflowerLogger getLogger() {
        return DecompilerContext.getCurrentContext().logger;
    }

    public static void setLogger(IFernflowerLogger logger) {
        String level;
        if (logger != null && (level = (String)DecompilerContext.getProperty("log")) != null) {
            try {
                logger.setSeverity(IFernflowerLogger.Severity.valueOf(level.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        DecompilerContext.getCurrentContext().logger = logger;
    }

    public static String getNewLineSeparator() {
        return DecompilerContext.getOption("nls") ? "\n" : "\r\n";
    }
}

