/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class SequenceHelper {
    public static void condenseSequences(Statement root) {
        SequenceHelper.condenseSequencesRec(root);
    }

    private static void condenseSequencesRec(Statement stat) {
        if (stat.type == 15) {
            ArrayList<Statement> lst = new ArrayList<Statement>();
            lst.addAll(stat.getStats());
            boolean unfolded = false;
            for (int i = 0; i < lst.size(); ++i) {
                Statement st = (Statement)lst.get(i);
                if (st.type != 15) continue;
                SequenceHelper.removeEmptyStatements((SequenceStatement)st);
                if (i != lst.size() - 1 && !SequenceHelper.isSequenceDisbandable(st, (Statement)lst.get(i + 1))) continue;
                Statement first = st.getFirst();
                for (StatEdge edge : st.getAllPredecessorEdges()) {
                    st.removePredecessor(edge);
                    edge.getSource().changeEdgeNode(1, edge, first);
                    first.addPredecessor(edge);
                }
                Statement last = st.getStats().getLast();
                if (last.getAllSuccessorEdges().isEmpty() && i < lst.size() - 1) {
                    last.addSuccessor(new StatEdge(1, last, (Statement)lst.get(i + 1)));
                } else {
                    for (StatEdge edge : last.getAllSuccessorEdges()) {
                        if (i == lst.size() - 1) {
                            if (edge.closure != st) continue;
                            stat.addLabeledEdge(edge);
                            continue;
                        }
                        edge.getSource().changeEdgeType(1, edge, 1);
                        edge.closure.getLabelEdges().remove(edge);
                        edge.closure = null;
                    }
                }
                for (StatEdge edge : st.getAllSuccessorEdges()) {
                    st.removeSuccessor(edge);
                }
                for (StatEdge edge : new HashSet<StatEdge>(st.getLabelEdges())) {
                    if (edge.getSource() == last) continue;
                    last.addLabeledEdge(edge);
                }
                lst.remove(i);
                lst.addAll(i, st.getStats());
                --i;
                unfolded = true;
            }
            if (unfolded) {
                SequenceStatement sequence = new SequenceStatement(lst);
                sequence.setAllParent();
                stat.getParent().replaceStatement(stat, sequence);
                stat = sequence;
            }
        }
        if (stat.type == 15) {
            SequenceHelper.removeEmptyStatements((SequenceStatement)stat);
            if (stat.getStats().size() == 1) {
                Statement st = stat.getFirst();
                boolean ok = st.getAllSuccessorEdges().isEmpty();
                if (!ok) {
                    StatEdge edge = st.getAllSuccessorEdges().get(0);
                    ok = stat.getAllSuccessorEdges().isEmpty();
                    if (!ok) {
                        StatEdge statedge = stat.getAllSuccessorEdges().get(0);
                        boolean bl = ok = edge.getDestination() == statedge.getDestination();
                        if (ok) {
                            st.removeSuccessor(edge);
                        }
                    }
                }
                if (ok) {
                    stat.getParent().replaceStatement(stat, st);
                    stat = st;
                }
            }
        }
        block5: while (true) {
            for (Statement st : stat.getStats()) {
                if (!st.getStats().isEmpty() && st.getExprents() == null || st.type == 8) continue;
                SequenceHelper.destroyAndFlattenStatement(st);
                continue block5;
            }
            break;
        }
        for (int i = 0; i < stat.getStats().size(); ++i) {
            SequenceHelper.condenseSequencesRec((Statement)stat.getStats().get(i));
        }
    }

    private static boolean isSequenceDisbandable(Statement block, Statement next) {
        Statement last = block.getStats().getLast();
        List<StatEdge> lstSuccs = last.getAllSuccessorEdges();
        if (!lstSuccs.isEmpty() && lstSuccs.get(0).getDestination() != next) {
            return false;
        }
        for (StatEdge edge : next.getPredecessorEdges(4)) {
            if (last == edge.getSource() || last.containsStatementStrict(edge.getSource())) continue;
            return false;
        }
        return true;
    }

    private static void removeEmptyStatements(SequenceStatement sequence) {
        boolean found;
        if (sequence.getStats().size() <= 1) {
            return;
        }
        SequenceHelper.mergeFlatStatements(sequence);
        block0: do {
            found = false;
            for (Statement st : sequence.getStats()) {
                if (st.getExprents() == null || !st.getExprents().isEmpty()) continue;
                if (st.getAllSuccessorEdges().isEmpty()) {
                    List<StatEdge> lstBreaks = st.getPredecessorEdges(4);
                    if (lstBreaks.isEmpty()) {
                        for (StatEdge edge : st.getAllPredecessorEdges()) {
                            edge.getSource().removeSuccessor(edge);
                        }
                        found = true;
                    }
                } else {
                    StatEdge sucedge = st.getAllSuccessorEdges().get(0);
                    if (sucedge.getType() != 32) {
                        st.removeSuccessor(sucedge);
                        for (StatEdge edge : st.getAllPredecessorEdges()) {
                            if (sucedge.getType() != 1) {
                                edge.getSource().changeEdgeType(1, edge, sucedge.getType());
                            }
                            st.removePredecessor(edge);
                            edge.getSource().changeEdgeNode(1, edge, sucedge.getDestination());
                            sucedge.getDestination().addPredecessor(edge);
                            if (sucedge.closure == null) continue;
                            sucedge.closure.addLabeledEdge(edge);
                        }
                        found = true;
                    }
                }
                if (!found) continue;
                sequence.getStats().removeWithKey(st.id);
                continue block0;
            }
        } while (found);
        sequence.setFirst((Statement)sequence.getStats().get(0));
    }

    private static void mergeFlatStatements(SequenceStatement sequence) {
        boolean found;
        do {
            Statement next = null;
            Statement current = null;
            found = false;
            for (int i = sequence.getStats().size() - 1; i >= 0; --i) {
                next = current;
                current = (Statement)sequence.getStats().get(i);
                if (next == null || current.getExprents() == null || current.getExprents().isEmpty()) continue;
                if (next.getExprents() != null) {
                    next.getExprents().addAll(0, current.getExprents());
                    current.getExprents().clear();
                    found = true;
                    continue;
                }
                Statement first = SequenceHelper.getFirstExprentlist(next);
                if (first == null) continue;
                first.getExprents().addAll(0, current.getExprents());
                current.getExprents().clear();
                found = true;
            }
        } while (found);
    }

    private static Statement getFirstExprentlist(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        switch (stat.type) {
            case 2: 
            case 6: 
            case 10: 
            case 15: {
                return SequenceHelper.getFirstExprentlist(stat.getFirst());
            }
        }
        return null;
    }

    public static void destroyAndFlattenStatement(Statement stat) {
        SequenceHelper.destroyStatementContent(stat, false);
        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        if (stat.getExprents() == null) {
            bstat.setExprents(new ArrayList<Exprent>());
        } else {
            bstat.setExprents(DecHelper.copyExprentList(stat.getExprents()));
        }
        stat.getParent().replaceStatement(stat, bstat);
    }

    public static void destroyStatementContent(Statement stat, boolean self) {
        for (Statement st : stat.getStats()) {
            SequenceHelper.destroyStatementContent(st, true);
        }
        stat.getStats().clear();
        if (self) {
            for (StatEdge edge : stat.getAllSuccessorEdges()) {
                stat.removeSuccessor(edge);
            }
        }
    }
}

