/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.GenericDominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraph;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionEdge;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class VarVersionsGraph {
    public int counter = 0;
    public VBStyleCollection<VarVersionNode, VarVersionPair> nodes = new VBStyleCollection();
    private GenericDominatorEngine engine;

    public VarVersionNode createNode(VarVersionPair ver) {
        VarVersionNode node = new VarVersionNode(ver.var, ver.version);
        this.nodes.addWithKey(node, ver);
        return node;
    }

    public void addNodes(Collection<VarVersionNode> colnodes, Collection<VarVersionPair> colpaars) {
        this.nodes.addAllWithKey(colnodes, colpaars);
    }

    public boolean isDominatorSet(VarVersionNode node, HashSet<VarVersionNode> domnodes) {
        if (domnodes.size() == 1) {
            return this.engine.isDominator(node, domnodes.iterator().next());
        }
        HashSet<VarVersionNode> marked = new HashSet<VarVersionNode>();
        if (domnodes.contains(node)) {
            return true;
        }
        LinkedList<VarVersionNode> lstNodes = new LinkedList<VarVersionNode>();
        lstNodes.add(node);
        while (!lstNodes.isEmpty()) {
            VarVersionNode nd = (VarVersionNode)lstNodes.remove(0);
            if (marked.contains(nd)) continue;
            marked.add(nd);
            if (nd.preds.isEmpty()) {
                return false;
            }
            for (VarVersionEdge edge : nd.preds) {
                VarVersionNode pred = edge.source;
                if (marked.contains(pred) || domnodes.contains(pred)) continue;
                lstNodes.add(pred);
            }
        }
        return true;
    }

    public void initDominators() {
        final HashSet<VarVersionNode> roots = new HashSet<VarVersionNode>();
        for (VarVersionNode node : this.nodes) {
            if (!node.preds.isEmpty()) continue;
            roots.add(node);
        }
        this.engine = new GenericDominatorEngine(new IGraph(){

            @Override
            public List<? extends IGraphNode> getReversePostOrderList() {
                return VarVersionsGraph.getReversedPostOrder(roots);
            }

            @Override
            public Set<? extends IGraphNode> getRoots() {
                return new HashSet(roots);
            }
        });
        this.engine.initialize();
    }

    private static LinkedList<VarVersionNode> getReversedPostOrder(Collection<VarVersionNode> roots) {
        LinkedList<VarVersionNode> lst = new LinkedList<VarVersionNode>();
        HashSet<VarVersionNode> setVisited = new HashSet<VarVersionNode>();
        for (VarVersionNode root : roots) {
            LinkedList<VarVersionNode> lstTemp = new LinkedList<VarVersionNode>();
            VarVersionsGraph.addToReversePostOrderListIterative(root, lstTemp, setVisited);
            lst.addAll(lstTemp);
        }
        return lst;
    }

    private static void addToReversePostOrderListIterative(VarVersionNode root, List<VarVersionNode> lst, HashSet<VarVersionNode> setVisited) {
        HashMap<VarVersionNode, ArrayList<VarVersionEdge>> mapNodeSuccs = new HashMap<VarVersionNode, ArrayList<VarVersionEdge>>();
        LinkedList<VarVersionNode> stackNode = new LinkedList<VarVersionNode>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            VarVersionNode node = (VarVersionNode)stackNode.getLast();
            int index = (Integer)stackIndex.removeLast();
            setVisited.add(node);
            ArrayList<VarVersionEdge> lstSuccs = (ArrayList<VarVersionEdge>)mapNodeSuccs.get(node);
            if (lstSuccs == null) {
                lstSuccs = new ArrayList<VarVersionEdge>(node.succs);
                mapNodeSuccs.put(node, lstSuccs);
            }
            while (index < lstSuccs.size()) {
                VarVersionNode succ = ((VarVersionEdge)lstSuccs.get((int)index)).dest;
                if (!setVisited.contains(succ)) {
                    stackIndex.add(index + 1);
                    stackNode.add(succ);
                    stackIndex.add(0);
                    break;
                }
                ++index;
            }
            if (index != lstSuccs.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }
}

