/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskStateCombo
extends JPanel {
    private final Project myProject;
    private final Task myTask;
    private final TemplateKindCombo myKindCombo = new TemplateKindCombo();

    public static boolean stateUpdatesSupportedFor(@Nullable Task task) {
        if (task == null || !task.isIssue()) {
            return false;
        }
        TaskRepository repository = task.getRepository();
        return repository != null && repository.isSupported(8);
    }

    public TaskStateCombo() {
        this(null, null);
    }

    public TaskStateCombo(Project project, Task task) {
        this.myProject = project;
        this.myTask = task;
        JBLabel hintLabel = new JBLabel();
        hintLabel.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        hintLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the state");
        JComboBox comboBox = this.myKindCombo.getComboBox();
        comboBox.setPreferredSize(new Dimension(300, UIUtil.fixComboBoxHeight((int)comboBox.getPreferredSize().height)));
        this.setLayout(new BoxLayout(this, 2));
        this.add((Component)this.myKindCombo);
        this.add((Component)hintLabel);
    }

    public boolean scheduleUpdateOnce() {
        if (this.myProject != null && TaskStateCombo.stateUpdatesSupportedFor(this.myTask) && this.myKindCombo.getComboBox().getItemCount() == 0) {
            JComboBox comboBox = this.myKindCombo.getComboBox();
            final TaskRepository repository = this.myTask.getRepository();
            assert (repository != null);
            new TaskUiUtil.ComboBoxUpdater<CustomStateTrinityAdapter>(this.myProject, "Fetching available task states...", comboBox){

                @Override
                @NotNull
                protected List<CustomStateTrinityAdapter> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskStateCombo$1", "fetch"));
                    }
                    List<CustomStateTrinityAdapter> list = CustomStateTrinityAdapter.wrapList(repository.getAvailableTaskStates(TaskStateCombo.this.myTask));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskStateCombo$1", "fetch"));
                    }
                    return list;
                }

                @Override
                @Nullable
                public CustomStateTrinityAdapter getSelectedItem() {
                    CustomTaskState state = TaskStateCombo.this.getPreferredState(repository, CustomStateTrinityAdapter.unwrapList((Collection)this.myResult));
                    return state != null ? new CustomStateTrinityAdapter(state) : null;
                }
            }.queue();
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myKindCombo.setEnabled(enabled);
    }

    @Nullable
    public CustomTaskState getSelectedState() {
        CustomStateTrinityAdapter item = (CustomStateTrinityAdapter)((Object)this.myKindCombo.getComboBox().getSelectedItem());
        if (item == null) {
            return null;
        }
        return item.myState;
    }

    public void registerUpDownAction(@NotNull JComponent focusable) {
        if (focusable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusable", "com/intellij/tasks/impl/TaskStateCombo", "registerUpDownAction"));
        }
        this.myKindCombo.registerUpDownHint(focusable);
    }

    @NotNull
    public JComboBox getComboBox() {
        JComboBox jComboBox = this.myKindCombo.getComboBox();
        if (jComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskStateCombo", "getComboBox"));
        }
        return jComboBox;
    }

    @Nullable
    protected abstract CustomTaskState getPreferredState(@NotNull TaskRepository var1, @NotNull Collection<CustomTaskState> var2);

    private static class CustomStateTrinityAdapter
    extends Trinity<String, Icon, String> {
        final CustomTaskState myState;

        public CustomStateTrinityAdapter(@NotNull CustomTaskState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter", "<init>"));
            }
            super((Object)state.getPresentableName(), null, (Object)state.getId());
            this.myState = state;
        }

        @NotNull
        static List<CustomStateTrinityAdapter> wrapList(@NotNull Collection<CustomTaskState> states) {
            if (states == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter", "wrapList"));
            }
            List list = ContainerUtil.map(states, (Function)new Function<CustomTaskState, CustomStateTrinityAdapter>(){

                public CustomStateTrinityAdapter fun(CustomTaskState state) {
                    return new CustomStateTrinityAdapter(state);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter", "wrapList"));
            }
            return list;
        }

        @NotNull
        static List<CustomTaskState> unwrapList(@NotNull Collection<CustomStateTrinityAdapter> wrapped) {
            if (wrapped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter", "unwrapList"));
            }
            List list = ContainerUtil.map(wrapped, (Function)new Function<CustomStateTrinityAdapter, CustomTaskState>(){

                public CustomTaskState fun(CustomStateTrinityAdapter adapter) {
                    return adapter.myState;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskStateCombo$CustomStateTrinityAdapter", "unwrapList"));
            }
            return list;
        }
    }
}

