/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.stats.StatsTimeCollector;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.android.compiler.AndroidDexCompilerSettingsConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable"});
    public static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    private static final Key<Long> PROJECT_LAST_SYNC_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.sync.timestamp");
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    private final Object myLock;
    @GuardedBy(value="myLock")
    private boolean mySyncInProgress;
    @GuardedBy(value="myLock")
    private boolean mySyncTransparentChangeInProgress;

    @NotNull
    public static GradleSyncState getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/GradleSyncState", "getInstance"));
        }
        GradleSyncState gradleSyncState = (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
        if (gradleSyncState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "getInstance"));
        }
        return gradleSyncState;
    }

    public GradleSyncState(@NotNull Project project, @NotNull MessageBus messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/GradleSyncState", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/android/tools/idea/gradle/GradleSyncState", "<init>"));
        }
        this.myLock = new Object();
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void syncSkipped(long lastSyncTimestamp) {
        this.cleanUpProjectPreferences();
        this.setLastGradleSyncTimestamp(lastSyncTimestamp);
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSkipped(GradleSyncState.this.myProject);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStarted(boolean notifyUser) {
        this.cleanUpProjectPreferences();
        StatsTimeCollector.start("sync-time");
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = true;
            this.mySyncTransparentChangeInProgress = false;
        }
        if (notifyUser) {
            this.notifyUser();
        }
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(GradleSyncState.this.myProject);
            }
        });
    }

    public void syncFailed(final @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/GradleSyncState", "syncFailed"));
        }
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(GradleSyncState.this.myProject, message);
            }
        });
    }

    public void syncEnded() {
        LintUtils.sTryPrefixLookup = true;
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(GradleSyncState.this.myProject);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFinished() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = false;
            this.mySyncTransparentChangeInProgress = false;
        }
        this.setLastGradleSyncTimestamp(System.currentTimeMillis());
        StatsTimeCollector.stop("sync-time");
        this.notifyUser();
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        if (publishingTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishingTask", "com/android/tools/idea/gradle/GradleSyncState", "syncPublisher"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    public void notifyUser() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                VirtualFile[] files;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)GradleSyncState.this.myProject);
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)GradleSyncState.this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                BuildVariantView.getInstance(GradleSyncState.this.myProject).updateContents();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncInProgress;
        }
    }

    private void setLastGradleSyncTimestamp(long timestamp) {
        this.myProject.putUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY, (Object)timestamp);
    }

    public long getLastGradleSyncTimestamp() {
        Long timestamp = (Long)this.myProject.getUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY);
        return timestamp != null ? timestamp : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ThreeState isSyncNeeded() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySyncTransparentChangeInProgress) {
                ThreeState threeState = ThreeState.NO;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "isSyncNeeded"));
                }
                return threeState;
            }
        }
        long lastSync = this.getLastGradleSyncTimestamp();
        if (lastSync < 0L) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "isSyncNeeded"));
            }
            return threeState;
        }
        ThreeState threeState = this.isSyncNeeded(lastSync) ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "isSyncNeeded"));
        }
        return threeState;
    }

    private boolean isSyncNeeded(long referenceTimeInMillis) {
        assert (referenceTimeInMillis > 0L);
        if (this.isSyncInProgress()) {
            return false;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        File settingsFilePath = new File(this.myProject.getBasePath(), "settings.gradle");
        if (settingsFilePath.exists()) {
            VirtualFile settingsFile = VfsUtil.findFileByIoFile((File)settingsFilePath, (boolean)true);
            if (settingsFile != null && fileDocumentManager.isFileModified(settingsFile)) {
                return true;
            }
            if (settingsFilePath.lastModified() > referenceTimeInMillis) {
                return true;
            }
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile == null) continue;
            if (fileDocumentManager.isFileModified(buildFile)) {
                return true;
            }
            File buildFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile);
            if (buildFilePath.lastModified() <= referenceTimeInMillis) continue;
            return true;
        }
        return false;
    }

    private void cleanUpProjectPreferences() {
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return;
        }
        try {
            ExtensionPoint projectConfigurable = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(Configurable.PROJECT_CONFIGURABLE);
            GradleUtil.cleanUpPreferences((ExtensionPoint<ConfigurableEP<Configurable>>)projectConfigurable, PROJECT_PREFERENCES_TO_REMOVE);
        }
        catch (Throwable e) {
            String msg = String.format("Failed to clean up preferences for project '%1$s'", this.myProject.getName());
            LOG.info(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSyncTransparentAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/GradleSyncState", "runSyncTransparentAction"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isSyncNeeded() == ThreeState.NO) {
                this.mySyncTransparentChangeInProgress = true;
            }
        }
        try {
            action.run();
        }
        finally {
            object = this.myLock;
            synchronized (object) {
                if (this.isSyncNeeded() == ThreeState.NO) {
                    this.mySyncTransparentChangeInProgress = false;
                    this.myProject.putUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
                }
            }
        }
    }

    @VisibleForTesting
    public void resetTimestamp() {
        this.setLastGradleSyncTimestamp(-1L);
    }
}

