/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static final Logger LOG = Logger.getInstance(MakeBeforeRunTask.class);
    private static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "<init>"));
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (AndroidStudioSpecificInitializer.isAndroidStudio() && (runConfiguration instanceof AndroidRunConfigurationBase || GradleExperimentalSettings.getInstance().ENABLE_UNIT_TESTING_SUPPORT && runConfiguration instanceof JUnitConfiguration)) {
            return new MakeBeforeRunTask();
        }
        return null;
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList gradleTasks = Lists.newArrayList();
        for (Module module : moduleManager.getModules()) {
            IdeaGradleProject gradleProject;
            AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
            if (facet == null || (gradleProject = facet.getGradleProject()) == null) continue;
            gradleTasks.addAll(gradleProject.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MakeBeforeRunTask task) {
        return task.isValid();
    }

    public boolean executeTask(final DataContext context, final RunConfiguration configuration, ExecutionEnvironment env, final MakeBeforeRunTask task) {
        if (!Projects.isGradleProject(this.myProject) || !Projects.isDirectGradleInvocationEnabled(this.myProject)) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        final AtomicBoolean success = new AtomicBoolean();
        try {
            String errorMsg;
            final Semaphore done = new Semaphore();
            done.down();
            final AtomicReference errorMsgRef = new AtomicReference();
            GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
            if (syncState.isSyncNeeded() != ThreeState.NO) {
                GradleProjectImporter.getInstance().syncProjectSynchronously(this.myProject, false, new GradleSyncListener.Adapter(){

                    @Override
                    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                        }
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1", "syncFailed"));
                        }
                        errorMsgRef.set(errorMessage);
                    }
                });
            }
            if ((errorMsg = (String)errorMsgRef.get()) != null) {
                LOG.info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
                return false;
            }
            final GradleInvoker gradleInvoker = GradleInvoker.getInstance(this.myProject);
            final GradleInvoker.AfterGradleInvocationTask afterTask = new GradleInvoker.AfterGradleInvocationTask(){

                @Override
                public void execute(@NotNull GradleInvocationResult result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$2", "execute"));
                    }
                    success.set(result.isBuildSuccessful());
                    gradleInvoker.removeAfterGradleInvocationTask(this);
                    done.up();
                }
            };
            if (this.myProject.isDisposed()) {
                done.up();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Module[] modules = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getModules() : Projects.getModulesToBuildFromSelection(MakeBeforeRunTaskProvider.this.myProject, context);
                        GradleInvoker.TestCompileType testCompileType = MakeBeforeRunTaskProvider.getTestCompileType(configuration);
                        gradleInvoker.addAfterGradleInvocationTask(afterTask);
                        String goal = task.getGoal();
                        if (StringUtil.isEmpty((String)goal)) {
                            gradleInvoker.assemble(modules, testCompileType);
                        } else {
                            gradleInvoker.executeTasks(Lists.newArrayList((Object[])new String[]{goal}));
                        }
                    }
                });
                done.waitFor();
            }
        }
        catch (Throwable t) {
            LOG.info("Unable to launch 'Gradle-aware Make' task", t);
            return false;
        }
        return success.get();
    }

    @NotNull
    private static GradleInvoker.TestCompileType getTestCompileType(@Nullable RunConfiguration runConfiguration) {
        String id = runConfiguration != null ? runConfiguration.getType().getId() : null;
        GradleInvoker.TestCompileType testCompileType = GradleInvoker.getTestCompileType(id);
        if (testCompileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider", "getTestCompileType"));
        }
        return testCompileType;
    }
}

