/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.wizard.SmwSelectionTable;
import com.android.tools.idea.sdk.wizard.SmwSelectionTableModel;
import com.android.tools.idea.sdk.wizard.SmwState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.intellij.icons.AllIcons;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmwSelectionStep
extends TemplateWizardStep
implements Disposable {
    private final SmwState myWizardState;
    private JPanel myContentPanel;
    private JLabel myTextDescription;
    private JBLabel myLabelSdkPath;
    private JBTable myTable;
    private JPanel myToolbarPanel;
    private JLabel myErrorLabel;
    private SmwSelectionTableModel myTableModel;
    private boolean myInitOnce;

    public SmwSelectionStep(@NotNull SmwState wizardState, @Nullable TemplateWizardStep.UpdateListener updateListener) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardState", "com/android/tools/idea/sdk/wizard/SmwSelectionStep", "<init>"));
        }
        super(wizardState, null, null, null, updateListener);
        this.myInitOnce = true;
        this.myWizardState = wizardState;
        this.$$$setupUI$$$();
    }

    public void dispose() {
    }

    @Override
    public JComponent getComponent() {
        return this.myContentPanel;
    }

    private void createUIComponents() {
        this.myTable = new SmwSelectionTable();
    }

    @Override
    public void _init() {
        if (!this.myInitOnce) {
            return;
        }
        this.myInitOnce = false;
        super._init();
        SdkState sdkState = this.myWizardState.getSdkState();
        if (sdkState != null) {
            AndroidSdkData sdkData = sdkState.getSdkData();
            this.myLabelSdkPath.setText(sdkData.getLocalSdk().getLocation().getPath());
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SdkManager", this.getActionGroup(true), true);
        JComponent component = actionToolbar.getComponent();
        this.myToolbarPanel.add((Component)component, "West");
        SmwSelectionTableModel.LabelColumnInfo pkgColumn = new SmwSelectionTableModel.LabelColumnInfo("Package");
        SmwSelectionTableModel.InstallColumnInfo selColumn = new SmwSelectionTableModel.InstallColumnInfo("Installed");
        this.myTableModel = new SmwSelectionTableModel(pkgColumn, selColumn);
        Disposer.register((Disposable)this, (Disposable)this.myTableModel);
        pkgColumn.setModel(this.myTableModel);
        selColumn.setModel(this.myTableModel);
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SmwSelectionStep.this.update();
            }
        });
        ListSelectionModel lsm = this.myTable.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SmwSelectionStep.this.onTableSelection(e);
            }
        });
        this.onTableSelection(new ListSelectionEvent(lsm, lsm.getMinSelectionIndex(), lsm.getMaxSelectionIndex(), lsm.getValueIsAdjusting()));
        if (sdkState != null) {
            this.myTableModel.linkToSdkState(sdkState);
            Runnable onSuccess = new Runnable(){

                @Override
                public void run() {
                    ListSelectionModel lsm = SmwSelectionStep.this.myTable.getSelectionModel();
                    SmwSelectionStep.this.onTableSelection(new ListSelectionEvent(lsm, lsm.getMinSelectionIndex(), lsm.getMaxSelectionIndex(), lsm.getValueIsAdjusting()));
                }
            };
            sdkState.loadAsync(600000L, false, onSuccess, null);
        }
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myErrorLabel;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwSelectionStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myErrorLabel;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwSelectionStep", "getError"));
        }
        return jLabel;
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        this.myWizardState.setSelectedActions(this.myTableModel.getActions());
        super._commit(finishChosen);
    }

    @Override
    public boolean validate() {
        if (this.myTableModel != null && this.myTableModel.getActions().isEmpty()) {
            return false;
        }
        return super.validate();
    }

    private void onTableSelection(ListSelectionEvent e) {
        IListDescription item;
        Object src = e.getSource();
        if (!(src instanceof ListSelectionModel) || e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)src;
        StringBuilder sb = new StringBuilder("<html>");
        IListDescription iListDescription = item = lsm.isSelectionEmpty() ? null : this.myTableModel.getObjectAt(lsm.getMinSelectionIndex());
        if (item == null) {
            sb.append("Please select a package to see its details.");
        } else {
            LocalPkgInfo lpi;
            if (item instanceof IDescription) {
                sb.append(((IDescription)item).getLongDescription());
            } else {
                sb.append(item.getListDescription());
            }
            if (item instanceof LocalPkgInfo && (lpi = (LocalPkgInfo)item).hasUpdate()) {
                assert (lpi.getUpdate() != null);
                sb.append("\n\n").append(lpi.getUpdate().getLongDescription());
            }
        }
        sb.append("</html>");
        this.myTextDescription.setText(sb.toString().replace("\n", "<br/>\n"));
    }

    protected ActionGroup getActionGroup(boolean inToolbar) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new RefreshAction("Refresh", "Refresh list", AllIcons.Actions.Refresh));
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add((AnAction)new SdkStateNeededAction("Install", "Install item", AllIcons.Actions.Install));
        actionGroup.add((AnAction)new SdkStateNeededAction("Uninstall", "Uninstall item", AllIcons.Actions.Uninstall));
        return actionGroup;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("SDK Path:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel = new JBLabel();
        jBLabel.setText("<placeholder path>");
        jBLabel.setOpaque(true);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        jPanel2.add((Component)jSplitPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myTextDescription = jLabel2 = new JLabel();
        ((Component)jLabel2).setBackground(UIManager.getColor("TextPane.background"));
        jLabel2.setText("Label");
        jLabel2.setOpaque(true);
        jLabel2.setVerticalTextPosition(3);
        jLabel2.setVerticalAlignment(1);
        jSplitPane.setRightComponent(jLabel2);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane);
        JBTable jBTable = this.myTable;
        jBScrollPane.setViewportView((Component)jBTable);
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    protected class RefreshAction
    extends SdkStateNeededAction {
        public RefreshAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            SdkState sdkState = SmwSelectionStep.this.myWizardState.getSdkState();
            if (sdkState != null) {
                sdkState.loadAsync(0L, false, null, null);
            }
        }
    }

    protected class SdkStateNeededAction
    extends DumbAwareAction {
        public SdkStateNeededAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        public void actionPerformed(AnActionEvent e) {
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(SmwSelectionStep.this.myWizardState.getSdkState() != null);
        }
    }
}

