/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.BuildToolInfo;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.WizardPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NewModuleWizardState
extends TemplateWizardState {
    private static final Logger LOG = Logger.getInstance(NewModuleWizardState.class);
    public static final String ATTR_CREATE_ACTIVITY = "createActivity";
    public static final String ATTR_PROJECT_LOCATION = "projectLocation";
    public static final String APP_NAME = "app";
    public static final String LIB_NAME = "lib";
    public static final String MODULE_IMPORT_NAME = "Import Existing Project";
    public static final String ARCHIVE_IMPORT_NAME = "Import .JAR or .AAR Package";
    protected final TemplateWizardState myActivityTemplateState;
    private Map<String, VirtualFile> myModulesToImport;
    private Map<String, WizardPath> myTemplateToPathMap = new HashMap<String, WizardPath>();
    private WizardPath myActiveWizardPath;
    private WizardPath myDefaultPath;

    public NewModuleWizardState() {
        this.myActivityTemplateState = new TemplateWizardState();
        this.myHidden.add(ATTR_PROJECT_LOCATION);
        this.myHidden.remove("isLibraryProject");
        this.put("isLauncher", false);
        this.put("createIcons", false);
        this.put("isNewProject", true);
        this.put(ATTR_CREATE_ACTIVITY, true);
        this.put("isLibraryProject", false);
        this.putSdkDependentParams();
        try {
            this.myActivityTemplateState.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
        }
        this.myActivityTemplateState.myHidden.add("packageName");
        this.myActivityTemplateState.myHidden.add("appTitle");
        this.myActivityTemplateState.myHidden.add("minApi");
        this.myActivityTemplateState.myHidden.add("minApiLevel");
        this.myActivityTemplateState.myHidden.add("targetApi");
        this.myActivityTemplateState.myHidden.add("targetApiString");
        this.myActivityTemplateState.myHidden.add("buildApi");
        this.myActivityTemplateState.myHidden.add("buildApiString");
        this.myActivityTemplateState.myHidden.add("copyIcons");
        this.myActivityTemplateState.myHidden.add("isLauncher");
        this.myActivityTemplateState.myHidden.add("parentActivityClass");
        this.myActivityTemplateState.myHidden.add("activityTitle");
        this.updateParameters();
    }

    public static boolean isAndroidTemplate(@Nullable TemplateMetadata templateMetadata) {
        return templateMetadata != null && templateMetadata.getParameter("minApi") != null;
    }

    public void setDefaultWizardPath(WizardPath defaultPath) {
        this.myDefaultPath = defaultPath;
    }

    public void templateChanged(@Nullable Project project, String templateName) {
        this.setTemplateName(templateName);
        if (templateName.equals("Android Library")) {
            this.put("isLibraryProject", true);
            this.put("isLauncher", false);
            this.put("createIcons", false);
            this.myHidden.add("createIcons");
        } else if (templateName.equals("Android Application")) {
            this.put("isLibraryProject", false);
            this.put("isLauncher", true);
            this.put("createIcons", true);
            this.myHidden.remove("createIcons");
        }
        if (this.myHidden.contains("appTitle")) {
            assert (project != null) : "Cannot be adding a module to a unknown project";
            this.put("appTitle", project.getName());
        }
    }

    private void setTemplateName(@Nullable String templateName) {
        this.myActiveWizardPath = this.myTemplateToPathMap.get(templateName);
    }

    @NotNull
    public WizardPath getActiveWizardPath() {
        WizardPath wizardPath = this.myActiveWizardPath != null ? this.myActiveWizardPath : this.myDefaultPath;
        if (wizardPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewModuleWizardState", "getActiveWizardPath"));
        }
        return wizardPath;
    }

    public void putSdkDependentParams() {
        BuildToolInfo buildTool;
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        BuildToolInfo buildToolInfo = buildTool = sdkData != null ? sdkData.getLatestBuildTool() : null;
        if (buildTool != null) {
            this.put("buildToolsVersion", buildTool.getRevision().toString());
        }
        if (sdkData != null) {
            this.put("sdkDir", FileUtil.toSystemIndependentName((String)sdkData.getPath()));
        }
    }

    @NotNull
    public TemplateWizardState getActivityTemplateState() {
        TemplateWizardState templateWizardState = this.myActivityTemplateState;
        if (templateWizardState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewModuleWizardState", "getActivityTemplateState"));
        }
        return templateWizardState;
    }

    public void updateDependencies() {
        HashSet dependencySet = new HashSet();
        if (this.myParameters.containsKey("dependencyList")) {
            dependencySet.addAll((Collection)this.get("dependencyList"));
        }
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        if (this.get("usesFragments") != null && Boolean.parseBoolean(this.get("usesFragments").toString()) || this.get("usesNavigationDrawer") != null && Boolean.parseBoolean(this.get("usesNavigationDrawer").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("support-v4"));
        }
        if (this.get("usesActionBar") != null && Boolean.parseBoolean(this.get("usesActionBar").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("appcompat-v7"));
        }
        if (this.get("usesGridLayout") != null && Boolean.parseBoolean(this.get("usesGridLayout").toString())) {
            dependencySet.add(urlManager.getLibraryCoordinate("gridlayout-v7"));
        }
        this.put("dependencyList", new LinkedList(dependencySet));
    }

    public void updateParameters() {
        this.put("copyIcons", !Boolean.parseBoolean(this.get("createIcons").toString()));
        this.copyParameters(this.myParameters, this.myActivityTemplateState.myParameters, "packageName", "appTitle", "minApi", "minApiLevel", "targetApi", "targetApiString", "buildApiString", "buildApi", "copyIcons", "isNewProject", "isLauncher", ATTR_CREATE_ACTIVITY, "createIcons", "isGradle", "topOut", "projectOut", "srcOut", "testOut", "resOut", "manifestOut");
    }

    protected void copyParameters(@NotNull Map<String, Object> from, @NotNull Map<String, Object> to, String ... keys) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/wizard/NewModuleWizardState", "copyParameters"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/wizard/NewModuleWizardState", "copyParameters"));
        }
        for (String key : keys) {
            to.put(key, from.get(key));
        }
    }

    @Nullable
    public Map<String, VirtualFile> getModulesToImport() {
        return this.myModulesToImport;
    }

    public void setModulesToImport(@Nullable Map<String, VirtualFile> modulesToImport) {
        this.myModulesToImport = modulesToImport;
    }

    public void associateTemplateWithPath(String templateName, WizardPath path) {
        this.myTemplateToPathMap.put(templateName, path);
        if (this.myActiveWizardPath == null) {
            this.myActiveWizardPath = path;
        }
    }

    public boolean isOnDefaultWizardPath() {
        return this.myActiveWizardPath == this.myDefaultPath;
    }
}

