/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;

public class HostKey {
    private static final byte[] sshdss = "ssh-dss".getBytes();
    private static final byte[] sshrsa = "ssh-rsa".getBytes();
    protected static final int GUESS = 0;
    public static final int SSHDSS = 1;
    public static final int SSHRSA = 2;
    static final int UNKNOWN = 3;
    protected String host;
    protected int type;
    protected byte[] key;

    public HostKey(String string, byte[] byArray) throws JSchException {
        this(string, 0, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostKey(String string, int n, byte[] byArray) throws JSchException {
        this.host = string;
        if (n == 0) {
            if (byArray[8] == 100) {
                this.type = 1;
            } else {
                if (byArray[8] != 114) throw new JSchException("invalid key type");
                this.type = 2;
            }
        } else {
            this.type = n;
        }
        this.key = byArray;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        if (this.type == 1) {
            return new String(sshdss);
        }
        if (this.type == 2) {
            return new String(sshrsa);
        }
        return "UNKNOWN";
    }

    public String getKey() {
        return new String(Util.toBase64(this.key, 0, this.key.length));
    }

    public String getFingerPrint(JSch jSch) {
        HASH hASH = null;
        try {
            Class<?> clazz = Class.forName(jSch.getConfig("md5"));
            hASH = (HASH)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("getFingerPrint: " + exception);
        }
        return Util.getFingerPrint(hASH, this.key);
    }

    boolean isMatched(String string) {
        return this.isIncluded(string);
    }

    private boolean isIncluded(String string) {
        int n = 0;
        String string2 = this.host;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n2) {
            int n4 = string2.indexOf(44, n);
            if (n4 == -1) {
                if (n3 != n2 - n) {
                    return false;
                }
                return string2.regionMatches(true, n, string, 0, n3);
            }
            if (n3 == n4 - n && string2.regionMatches(true, n, string, 0, n3)) {
                return true;
            }
            n = n4 + 1;
        }
        return false;
    }
}

