/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import java.io.IOException;
import java.io.OutputStream;

public class WinPTYOutputStream
extends OutputStream {
    private final NamedPipe myNamedPipe;
    private boolean myClosed;
    private boolean myPatchNewline;

    public WinPTYOutputStream(NamedPipe namedPipe) {
        this(namedPipe, false);
    }

    public WinPTYOutputStream(NamedPipe namedPipe, boolean patchNewline) {
        this.myNamedPipe = namedPipe;
        this.myPatchNewline = patchNewline;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] tmpBuf;
        if (this.myClosed) {
            return;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.myPatchNewline) {
            tmpBuf = new byte[len * 2];
            int newLen = len;
            int ind_b = off;
            int ind_tmp = 0;
            while (ind_b < off + len) {
                if (b[ind_b] == 10) {
                    tmpBuf[ind_tmp++] = 13;
                    ++newLen;
                }
                tmpBuf[ind_tmp++] = b[ind_b++];
            }
            len = newLen;
        } else {
            tmpBuf = new byte[len];
            System.arraycopy(b, off, tmpBuf, 0, len);
        }
        this.myNamedPipe.write(tmpBuf, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        this.myClosed = true;
        this.myNamedPipe.markClosed();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

