/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenCompilerConfigurer
extends MavenModuleConfigurer {
    public static final Key<Boolean> IGNORE_MAVEN_COMPILER_TARGET_KEY = Key.create((String)"idea.maven.skip.compiler.target.level");

    @Override
    public void configure(@NotNull MavenProject mavenProject, @NotNull Project project, @Nullable Module module) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/importing/configurers/MavenCompilerConfigurer", "configure"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/importing/configurers/MavenCompilerConfigurer", "configure"));
        }
        if (module == null) {
            return;
        }
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project);
        Boolean ignoreMavenCompilerTargetOption = (Boolean)module.getUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY);
        if (ignoreMavenCompilerTargetOption == null || !ignoreMavenCompilerTargetOption.booleanValue()) {
            String targetLevel = mavenProject.getTargetLevel();
            configuration.setBytecodeTargetLevel(module, (String)ObjectUtils.notNull((Object)targetLevel, (Object)"1.5"));
        }
        module.putUserData(IGNORE_MAVEN_COMPILER_TARGET_KEY, (Object)Boolean.FALSE);
        VirtualFile dir = VfsUtil.findRelativeFile((VirtualFile)mavenProject.getDirectoryFile(), (String[])new String[]{"src", "main", "resources", "archetype-resources"});
        if (dir != null && !configuration.isExcludedFromCompilation(dir)) {
            ExcludesConfiguration cfg = configuration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)project));
        }
    }
}

