/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStaticImportMethodFix
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix");
    private final SmartPsiElementPointer<GrMethodCall> myMethodCall;
    private List<PsiMethod> myCandidates;

    public GroovyStaticImportMethodFix(@NotNull GrMethodCall methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "<init>"));
        }
        this.myCandidates = null;
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    public String getText() {
        String text = "Static import method";
        if (this.getCandidates().size() == 1) {
            int options = 6145;
            text = text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.getCandidates().get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'";
        } else {
            text = text + "...";
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static GrReferenceExpression getMethodExpression(GrMethodCall call) {
        GrExpression result = call.getInvokedExpression();
        return result instanceof GrReferenceExpression ? (GrReferenceExpression)result : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "isAvailable"));
        }
        this.myCandidates = null;
        return this.myMethodCall.getElement() != null && ((GrMethodCall)this.myMethodCall.getElement()).isValid() && GroovyStaticImportMethodFix.getMethodExpression((GrMethodCall)this.myMethodCall.getElement()) != null && GroovyStaticImportMethodFix.getMethodExpression((GrMethodCall)this.myMethodCall.getElement()).getQualifierExpression() == null && file.getManager().isInProject((PsiElement)file) && !this.getCandidates().isEmpty();
    }

    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.myMethodCall.getProject());
        GrMethodCall element = (GrMethodCall)this.myMethodCall.getElement();
        LOG.assertTrue(element != null);
        GrReferenceExpression reference = GroovyStaticImportMethodFix.getMethodExpression(element);
        LOG.assertTrue(reference != null);
        GrArgumentList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            ArrayList<PsiMethod> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "getMethodsToImport"));
            }
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, 20);
        ArrayList<PsiMethod> applicableList = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            PsiFile file;
            ProgressManager.checkCanceled();
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)method, (boolean)false) || !method.hasModifierProperty("static") || !((file = method.getContainingFile()) instanceof PsiClassOwner) || ((PsiClassOwner)file).getPackageName().isEmpty() || !PsiUtil.isAccessible(element, (PsiMember)method)) continue;
            list.add(method);
            if (!PsiUtil.isApplicable(PsiUtil.getArgumentTypes(element, true), method, PsiSubstitutor.EMPTY, element, false)) continue;
            applicableList.add(method);
        }
        ArrayList<PsiMethod> result = applicableList.isEmpty() ? list : applicableList;
        Collections.sort(result, new PsiProximityComparator((PsiElement)argumentList));
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "getMethodsToImport"));
        }
        return arrayList;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "processIntention"));
        }
        PsiFile file = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        if (this.getCandidates().size() == 1) {
            PsiMethod toImport = this.getCandidates().get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return true;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyStaticImportMethodFix", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private void doImport(final PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessToken accessToken = WriteAction.start();
                try {
                    try {
                        GrMethodCall element = (GrMethodCall)GroovyStaticImportMethodFix.this.myMethodCall.getElement();
                        if (element != null) {
                            GroovyStaticImportMethodFix.getMethodExpression(element).bindToElementViaStaticImport((PsiMember)toImport);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                finally {
                    accessToken.finish();
                }
            }
        }, this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor) {
        JBList list = new JBList((Object[])this.getCandidates().toArray(new PsiMethod[this.getCandidates().size()]));
        list.setCellRenderer(new MethodCellRenderer(true));
        new PopupChooserBuilder((JList)list).setTitle(QuickFixBundle.message((String)"static.import.method.choose.method.to.import", (Object[])new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                PsiMethod selectedValue = (PsiMethod)this.val$list.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                LOG.assertTrue(selectedValue.isValid());
                GroovyStaticImportMethodFix.this.doImport(selectedValue);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private List<PsiMethod> getCandidates() {
        if (this.myCandidates == null) {
            this.myCandidates = this.getMethodsToImport();
        }
        return this.myCandidates;
    }
}

