/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class MethodLateBoundReferencesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public MethodLateBoundReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher", "processQuery"));
        }
        PsiMethod method = queryParameters.getMethod();
        SearchScope searchScope = GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope()).intersectWith(MethodLateBoundReferencesSearcher.getUseScope(method));
        PsiClass aClass = method.getContainingClass();
        String className = aClass == null ? null : aClass.getName();
        MethodLateBoundReferencesSearcher.orderSearching(searchScope, method.getName(), method, queryParameters.getOptimizer(), method.getParameterList().getParametersCount());
        String propName = PropertyUtil.getPropertyName((PsiMethod)method);
        if (propName != null) {
            MethodLateBoundReferencesSearcher.orderSearching(searchScope, propName, method, queryParameters.getOptimizer(), -1);
        }
    }

    private static SearchScope getUseScope(PsiMethod method) {
        SearchScope scope = method.getUseScope();
        PsiFile file = method.getContainingFile();
        if (file != null && scope instanceof GlobalSearchScope) {
            VirtualFile vfile = file.getOriginalFile().getVirtualFile();
            Project project = method.getProject();
            if (vfile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(vfile)) {
                return new GrSourceFilterScope((GlobalSearchScope)scope);
            }
        }
        return scope;
    }

    private static void orderSearching(SearchScope searchScope, final String name, @NotNull PsiMethod searchTarget, @NotNull SearchRequestCollector collector, final int paramCount) {
        if (searchTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchTarget", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher", "orderSearching"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher", "orderSearching"));
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        collector.searchWord(name, searchScope, (short)1, true, (PsiElement)searchTarget, new RequestResultProcessor(new Object[]{"groovy.lateBound"}){

            public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher$1", "processTextOccurrence"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/groovy/findUsages/MethodLateBoundReferencesSearcher$1", "processTextOccurrence"));
                }
                if (!(element instanceof GrReferenceExpression)) {
                    return true;
                }
                GrReferenceExpression ref = (GrReferenceExpression)element;
                if (!name.equals(ref.getReferenceName()) || PsiUtil.isLValue(ref) || ref.resolve() != null) {
                    return true;
                }
                PsiElement parent = ref.getParent();
                if (parent instanceof GrMethodCall ? !MethodLateBoundReferencesSearcher.argumentsMatch((GrMethodCall)parent, paramCount) : ResolveUtil.isKeyOfMap(ref)) {
                    return true;
                }
                return consumer.process((Object)((PsiReference)element));
            }
        });
    }

    private static boolean argumentsMatch(GrMethodCall call, int paramCount) {
        int argCount = call.getExpressionArguments().length;
        if (PsiImplUtil.hasNamedArguments(call.getArgumentList())) {
            ++argCount;
        }
        return argCount == paramCount;
    }
}

