/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    private final Collection<TextRange> myRanges;
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(@NotNull PsiFile file, @NotNull SelectionModel selectionModel) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(file.getProject(), file, PROGRESS_TEXT, COMMAND_NAME, false);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor, @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(processor, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor, boolean processChangedTextOnly) {
        super(processor, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile file, @Nullable TextRange range, boolean processChangedTextOnly) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
        if (range != null) {
            this.myRanges.add(range);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(file.getProject(), file, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, final boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){
            private Document myDocument;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
                try {
                    Collection ranges = ReformatCodeProcessor.this.getRangesToFormat(processChangedTextOnly, file);
                    CharSequence before = null;
                    if (ReformatCodeProcessor.this.getInfoCollector() != null) {
                        this.myDocument = PsiDocumentManager.getInstance((Project)ReformatCodeProcessor.this.myProject).getDocument(file);
                        LOG.assertTrue(this.myDocument != null);
                        before = this.myDocument.getImmutableCharSequence();
                    }
                    CodeStyleManager.getInstance((Project)ReformatCodeProcessor.this.myProject).reformatText(file, ranges);
                    if (before != null) {
                        ReformatCodeProcessor.this.prepareUserNotificationMessage(this.myDocument, before);
                    }
                    Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                    return bl;
                }
                catch (FilesTooBigForDiffException e) {
                    ReformatCodeProcessor.this.handleFileTooBigException(LOG, e, file);
                    Boolean bl = false;
                    return bl;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    ReformatCodeProcessor.this.myRanges.clear();
                }
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareUserNotificationMessage"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareUserNotificationMessage"));
        }
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(boolean processChangedTextOnly, PsiFile file) throws FilesTooBigForDiffException {
        if (this.mySelectionModel != null) {
            List<TextRange> list = ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
            }
            return list;
        }
        if (processChangedTextOnly) {
            List<TextRange> list = FormatChangedTextUtil.getChangedTextRanges(this.myProject, file);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
            }
            return list;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file.getTextRange()});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
        }
        return arrayList;
    }
}

