/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerationNode
extends UserDataHolderBase {
    private final TemplateToken myTemplateToken;
    private final List<GenerationNode> myChildren = Lists.newArrayList();
    private final int myNumberInIteration;
    private final int myTotalIterations;
    private String mySurroundedText;
    private final boolean myInsertSurroundedTextAtTheEnd;
    private final boolean myInsertNewLineBetweenNodes;
    private GenerationNode myParent;
    private boolean myContainsSurroundedTextMarker = false;
    private static final Pattern ATTRIBUTE_VARIABLE_PATTERN = Pattern.compile("\\$[A-z_0-9]+\\$");
    private static final Pattern HREF_PATTERN = Pattern.compile("^(?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$])", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,5}$");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^([A-z]+:)?//");

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        this(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, false);
    }

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent, boolean insertNewLineBetweenNodes) {
        this.myTemplateToken = templateToken;
        this.myNumberInIteration = numberInIteration;
        this.myTotalIterations = totalIterations;
        this.mySurroundedText = surroundedText;
        this.myInsertSurroundedTextAtTheEnd = insertSurroundedTextAtTheEnd;
        this.myInsertNewLineBetweenNodes = insertNewLineBetweenNodes;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isInsertNewLineBetweenNodes() {
        return this.myInsertNewLineBetweenNodes;
    }

    public List<GenerationNode> getChildren() {
        return this.myChildren;
    }

    public void addChild(GenerationNode child) {
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void addChildren(Collection<GenerationNode> children) {
        for (GenerationNode child : children) {
            this.addChild(child);
        }
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    private boolean isBlockTag() {
        XmlTag tag;
        XmlFile xmlFile;
        XmlDocument document;
        if (this.myTemplateToken != null && (document = (xmlFile = this.myTemplateToken.getFile()).getDocument()) != null && (tag = document.getRootTag()) != null) {
            return HtmlUtil.isHtmlBlockTagL(tag.getName());
        }
        return false;
    }

    @NotNull
    public TemplateImpl generate(@NotNull CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, @NotNull Collection<ZenCodingFilter> filters, boolean insertSurroundedText, int segmentsLimit) {
        Map<String, String> predefinedValues;
        TemplateImpl parentTemplate;
        boolean hasChildren;
        String indentStr;
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        this.myContainsSurroundedTextMarker = !insertSurroundedText || !this.myInsertSurroundedTextAtTheEnd;
        GenerationNode generationNode = this;
        if (generationNode != this) {
            TemplateImpl templateImpl = generationNode.generate(callback, generator, Collections.<ZenCodingFilter>emptyList(), insertSurroundedText, segmentsLimit);
            if (templateImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
            }
            return templateImpl;
        }
        boolean shouldNotReformatTemplate = false;
        boolean oneLineTemplateExpanding = false;
        for (ZenCodingFilter filter : filters) {
            generationNode = filter.filterNode(generationNode);
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            shouldNotReformatTemplate = true;
            oneLineTemplateExpanding = true;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)callback.getProject());
        if (callback.isInInjectedFragment()) {
            Editor editor = callback.getEditor();
            Document document = editor.getDocument();
            if (document instanceof DocumentWindowImpl && ((DocumentWindowImpl)document).isOneLine()) {
                oneLineTemplateExpanding = true;
                filters.add(new SingleLineEmmetFilter());
            }
            indentStr = "";
        } else if (settings.useTabCharacter(callback.getFileType())) {
            indentStr = "\t";
        } else {
            int tabSize = settings.getTabSize(callback.getFileType());
            indentStr = StringUtil.repeatSymbol((char)' ', (int)tabSize);
        }
        LiveTemplateBuilder builder = new LiveTemplateBuilder(segmentsLimit);
        int end = -1;
        boolean bl = hasChildren = this.myChildren.size() > 0;
        if (this.myTemplateToken instanceof TemplateToken && generator instanceof XmlZenCodingGenerator) {
            TemplateToken xmlTemplateToken = this.myTemplateToken;
            parentTemplate = this.invokeXmlTemplate(xmlTemplateToken, callback, generator, hasChildren);
            predefinedValues = this.buildPredefinedValues(xmlTemplateToken.getAttributes(), (XmlZenCodingGenerator)generator, hasChildren);
        } else {
            parentTemplate = GenerationNode.invokeTemplate(this.myTemplateToken, hasChildren, callback, generator);
            predefinedValues = null;
        }
        String s = parentTemplate.getString();
        for (ZenCodingFilter filter : filters) {
            s = filter.filterText(s, this.myTemplateToken);
        }
        parentTemplate = parentTemplate.copy();
        parentTemplate.setString(s);
        String txt = hasChildren || this.myContainsSurroundedTextMarker ? null : this.mySurroundedText;
        parentTemplate = GenerationNode.expandTemplate(parentTemplate, predefinedValues, txt, segmentsLimit);
        int offset = builder.insertTemplate(0, parentTemplate, null);
        int newOffset = GenerationNode.gotoChild(callback.getProject(), builder.getText(), offset, 0, builder.length());
        if (offset < builder.length() && newOffset != offset) {
            end = offset;
        }
        offset = newOffset;
        if (end == -1 && offset < builder.length() && this.myChildren.size() == 0) {
            end = offset;
        }
        LiveTemplateBuilder.Marker marker = offset < builder.length() ? builder.createMarker(offset) : null;
        int myChildrenSize = this.myChildren.size();
        for (int i = 0; i < myChildrenSize; ++i) {
            GenerationNode child = this.myChildren.get(i);
            TemplateImpl childTemplate = child.generate(callback, generator, filters, !this.myContainsSurroundedTextMarker, segmentsLimit);
            boolean blockTag = child.isBlockTag();
            if (!oneLineTemplateExpanding && blockTag && !GenerationNode.isNewLineBefore(builder.getText(), offset)) {
                builder.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            int e = builder.insertTemplate(offset, childTemplate, null);
            int n = offset = marker != null ? marker.getEndOffset() : builder.length();
            if (!oneLineTemplateExpanding && (blockTag && !GenerationNode.isNewLineAfter(builder.getText(), offset) || this.myInsertNewLineBetweenNodes)) {
                builder.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            if (end != -1 || e >= offset) continue;
            end = e;
        }
        if (shouldNotReformatTemplate) {
            builder.setIsToReformat(false);
        }
        TemplateImpl templateImpl = builder.buildTemplate();
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        return templateImpl;
    }

    private static TemplateImpl invokeTemplate(TemplateToken token, boolean hasChildren, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator) {
        TemplateImpl template = token.getTemplate();
        if (generator != null) {
            assert (template != null);
            template = generator.generateTemplate(token, hasChildren, callback.getContext());
            GenerationNode.removeVariablesWhichHasNoSegment(template);
        }
        return template;
    }

    private TemplateImpl invokeXmlTemplate(TemplateToken token, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, boolean hasChildren) {
        ZenCodingGenerator zenCodingGenerator = (ZenCodingGenerator)ObjectUtils.notNull((Object)generator, (Object)XmlZenCodingGeneratorImpl.INSTANCE);
        Map<String, String> attributes = token.getAttributes();
        TemplateImpl template = token.getTemplate();
        assert (template != null);
        XmlFile xmlFile = token.getFile();
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)xmlFile.getProject());
        XmlFile dummyFile = (XmlFile)fileFactory.createFileFromText("dummy.html", (Language)HTMLLanguage.INSTANCE, (CharSequence)xmlFile.getText(), false, true);
        XmlTag tag = dummyFile.getRootTag();
        if (tag != null) {
            if (EmmetOptions.getInstance().isHrefAutoDetectEnabled() && StringUtil.isNotEmpty((String)this.mySurroundedText)) {
                boolean isEmptyLinkTag;
                boolean bl = isEmptyLinkTag = "a".equalsIgnoreCase(tag.getName()) && GenerationNode.isEmptyValue(tag.getAttributeValue("href"));
                if (!hasChildren && isEmptyLinkTag) {
                    if (HREF_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", PROTOCOL_PATTERN.matcher(this.mySurroundedText).find() ? this.mySurroundedText.trim() : "http://" + this.mySurroundedText.trim());
                    } else if (EMAIL_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", "mailto:" + this.mySurroundedText.trim());
                    }
                }
            }
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (!Strings.isNullOrEmpty((String)attribute.getValue())) continue;
                template.addVariable(GenerationNode.prepareVariableName(attribute.getKey()), "", "", true);
            }
            XmlTag tag1 = hasChildren ? GenerationNode.expandEmptyTagIfNecessary(tag) : tag;
            this.setAttributeValues(tag1, attributes, callback, zenCodingGenerator.isHtml(callback));
            XmlFile physicalFile = (XmlFile)fileFactory.createFileFromText((Language)HTMLLanguage.INSTANCE, (CharSequence)tag1.getContainingFile().getText());
            VirtualFile vFile = physicalFile.getVirtualFile();
            if (vFile != null) {
                vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
            }
            token.setFile(physicalFile);
        }
        template = zenCodingGenerator.generateTemplate(token, hasChildren, callback.getContext());
        GenerationNode.removeVariablesWhichHasNoSegment(template);
        return template;
    }

    private static String prepareVariableName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "prepareVariableName"));
        }
        char[] toReplace = new char[]{'-', '+', ':'};
        StringBuilder builder = new StringBuilder(attributeName.length());
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            boolean replaced = false;
            for (char aToReplace : toReplace) {
                if (c != aToReplace) continue;
                builder.append('_');
                replaced = true;
                break;
            }
            if (replaced) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    @NotNull
    private static TemplateImpl expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues, String surroundedText, int segmentsLimit) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
        }
        LiveTemplateBuilder builder = new LiveTemplateBuilder(segmentsLimit);
        if (predefinedVarValues == null && surroundedText == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
            }
            return templateImpl;
        }
        int offset = builder.insertTemplate(0, template, predefinedVarValues);
        if (surroundedText != null) {
            builder.insertText(offset, surroundedText, true);
            builder.setIsToReformat(true);
        }
        TemplateImpl templateImpl = builder.buildTemplate();
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
        }
        return templateImpl;
    }

    @NotNull
    private static XmlTag expandEmptyTagIfNecessary(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
        }
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (PsiElement child : tag.getChildren()) {
            if (child instanceof XmlToken && XmlTokenType.XML_EMPTY_ELEMENT_END.equals(((XmlToken)child).getTokenType())) {
                flag = true;
                break;
            }
            builder.append(child.getText());
        }
        if (flag) {
            builder.append("></").append(tag.getName()).append('>');
            XmlTag xmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)builder.toString(), (Language)XMLLanguage.INSTANCE);
            if (xmlTag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
            }
            return xmlTag;
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
        }
        return xmlTag;
    }

    private static int gotoChild(Project project, CharSequence text, int offset, int start, int end) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, text, LocalTimeCounter.currentTime(), false);
        PsiElement element = file.findElementAt(offset);
        if (offset < end && element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return offset;
        }
        int newOffset = -1;
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)start, (int)end, XmlTag.class);
        if (tag != null) {
            for (PsiElement child : tag.getChildren()) {
                if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            return newOffset;
        }
        return offset;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i;
        HashSet segments = new HashSet();
        for (i = 0; i < template.getSegmentsCount(); ++i) {
            segments.add(template.getSegmentName(i));
        }
        for (i = template.getVariableCount() - 1; i >= 0; --i) {
            String varName = template.getVariableNameAt(i);
            if (!segments.contains(varName)) {
                template.removeVariable(i);
                continue;
            }
            segments.remove(varName);
        }
    }

    @Nullable
    private Map<String, String> buildPredefinedValues(@NotNull Map<String, String> attributes, @Nullable XmlZenCodingGenerator generator, boolean hasChildren) {
        String attributesString;
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "buildPredefinedValues"));
        }
        if (generator == null) {
            return Collections.emptyMap();
        }
        for (String value : attributes.values()) {
            if (!ZenCodingUtil.containsSurroundedTextMarker(value)) continue;
            this.myContainsSurroundedTextMarker = true;
            break;
        }
        attributesString = (attributesString = generator.buildAttributesString(attributes, hasChildren, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText)).length() > 0 ? ' ' + attributesString : null;
        HashMap predefinedValues = null;
        if (attributesString != null) {
            predefinedValues = new HashMap();
            predefinedValues.put("ATTRS", attributesString);
        }
        return predefinedValues;
    }

    private void setAttributeValues(@NotNull XmlTag tag, final @NotNull Map<String, String> attributes, @NotNull CustomTemplateCallback callback, boolean isHtml) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "setAttributeValues"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "setAttributeValues"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "setAttributeValues"));
        }
        String defaultAttributeValue = attributes.get("%default");
        if (defaultAttributeValue != null) {
            String attributeName;
            attributes.remove("%default");
            List xmlAttributes = ContainerUtil.filter((Object[])tag.getAttributes(), (Condition)new Condition<XmlAttribute>(){

                public boolean value(XmlAttribute attribute) {
                    return !attributes.containsKey(attribute.getLocalName());
                }
            });
            XmlAttribute defaultAttribute = GenerationNode.findDefaultAttribute(xmlAttributes);
            if (defaultAttribute == null) {
                defaultAttribute = GenerationNode.findImpliedAttribute(xmlAttributes);
            }
            if (defaultAttribute == null) {
                defaultAttribute = GenerationNode.findEmptyAttribute(xmlAttributes);
            }
            if (defaultAttribute != null && (attributeName = defaultAttribute.getName()).length() > 1) {
                String oldValue;
                if (GenerationNode.isImpliedAttribute(attributeName) || GenerationNode.isDefaultAttribute(attributeName)) {
                    defaultAttribute.setName(attributeName.substring(1));
                }
                if ((oldValue = defaultAttribute.getValue()) != null && StringUtil.containsChar((String)oldValue, (char)'|')) {
                    defaultAttribute.setValue(StringUtil.replace((String)oldValue, (String)"|", (String)defaultAttributeValue));
                } else {
                    defaultAttribute.setValue(defaultAttributeValue);
                }
            }
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String attributeName = xmlAttribute.getName();
            XmlAttributeValue xmlAttributeValueElement = xmlAttribute.getValueElement();
            if (xmlAttributeValueElement != null && !attributes.containsKey(attributeName)) continue;
            String attributeValue = StringUtil.notNullize((String)attributes.get(attributeName), (String)StringUtil.notNullize((String)xmlAttribute.getValue()));
            if (ZenCodingUtil.containsSurroundedTextMarker(attributeValue)) {
                this.myContainsSurroundedTextMarker = true;
            }
            if (isHtml && GenerationNode.isBooleanAttribute(attributeValue, xmlAttribute, callback)) {
                if (HtmlUtil.isShortNotationOfBooleanAttributePreferred()) {
                    PsiElement prevSibling;
                    if (xmlAttributeValueElement == null || (prevSibling = xmlAttributeValueElement.getPrevSibling()) == null || !prevSibling.textMatches((CharSequence)"=")) continue;
                    xmlAttribute.deleteChildRange(prevSibling, (PsiElement)xmlAttributeValueElement);
                    continue;
                }
                if (xmlAttributeValueElement == null) {
                    xmlAttribute.delete();
                }
                tag.setAttribute(attributeName, attributeName);
                continue;
            }
            if (xmlAttributeValueElement == null) {
                xmlAttribute.delete();
            }
            tag.setAttribute(attributeName, StringUtil.isEmpty((String)attributeValue) ? "$" + GenerationNode.prepareVariableName(attributeName) + "$" : ZenCodingUtil.getValue(attributeValue, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText));
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String xmlAttributeLocalName = xmlAttribute.getLocalName();
            if (!GenerationNode.isImpliedAttribute(xmlAttributeLocalName) && !GenerationNode.isDefaultAttribute(xmlAttributeLocalName)) continue;
            xmlAttribute.delete();
        }
    }

    private static boolean isBooleanAttribute(@Nullable String attributeValue, @NotNull XmlAttribute xmlAttribute, @NotNull CustomTemplateCallback callback) {
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "isBooleanAttribute"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "isBooleanAttribute"));
        }
        if ("%boolean".equals(attributeValue)) {
            return true;
        }
        if (StringUtil.isEmpty((String)attributeValue)) {
            XmlAttributeDescriptor descriptor = xmlAttribute.getDescriptor();
            return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, callback.getContext());
        }
        return false;
    }

    private static boolean isDefaultAttribute(String xmlAttributeLocalName) {
        return StringUtil.startsWithChar((CharSequence)xmlAttributeLocalName, (char)'@');
    }

    private static boolean isImpliedAttribute(String xmlAttributeLocalName) {
        return StringUtil.startsWithChar((CharSequence)xmlAttributeLocalName, (char)'!');
    }

    private static boolean isEmptyValue(String attributeValue) {
        return StringUtil.isEmpty((String)attributeValue) || ATTRIBUTE_VARIABLE_PATTERN.matcher(attributeValue).matches();
    }

    @Nullable
    private static XmlAttribute findDefaultAttribute(@NotNull List<XmlAttribute> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "findDefaultAttribute"));
        }
        for (XmlAttribute attribute : attributes) {
            if (!GenerationNode.isDefaultAttribute(attribute.getLocalName())) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findImpliedAttribute(@NotNull List<XmlAttribute> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "findImpliedAttribute"));
        }
        for (XmlAttribute attribute : attributes) {
            if (!GenerationNode.isImpliedAttribute(attribute.getLocalName())) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findEmptyAttribute(@NotNull List<XmlAttribute> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "findEmptyAttribute"));
        }
        for (XmlAttribute attribute : attributes) {
            String attributeValue = attribute.getValue();
            if (!GenerationNode.isEmptyValue(attributeValue)) continue;
            return attribute;
        }
        return null;
    }

    private static boolean isNewLineBefore(CharSequence text, int offset) {
        int i;
        for (i = offset - 1; i >= 0 && Character.isWhitespace(text.charAt(i)); --i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i < 0;
    }

    private static boolean isNewLineAfter(CharSequence text, int offset) {
        int i;
        for (i = offset; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i == text.length();
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    public String getSurroundedText() {
        return this.mySurroundedText;
    }

    public void setSurroundedText(String surroundedText) {
        this.mySurroundedText = surroundedText;
    }

    public GenerationNode getParent() {
        return this.myParent;
    }

    public void setParent(GenerationNode parent) {
        this.myParent = parent;
    }
}

