/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup {
    private final Project myProject;
    private final InspectionManagerEx myManager;
    private final Set<InspectionTreeNode> myNodesToSuppress;
    private final InspectionToolWrapper myToolWrapper;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.actions.SuppressActionWrapper");

    public SuppressActionWrapper(@NotNull Project project, @NotNull InspectionToolWrapper toolWrapper, @NotNull TreePath[] paths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/actions/SuppressActionWrapper", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/actions/SuppressActionWrapper", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/codeInspection/ui/actions/SuppressActionWrapper", "<init>"));
        }
        super(InspectionsBundle.message((String)"suppress.inspection.problem", (Object[])new Object[0]), false);
        this.myNodesToSuppress = new HashSet();
        this.myProject = project;
        this.myManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof TreeNode)) continue;
            TreeUtil.traverse((TreeNode)((TreeNode)node), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    InspectionTreeNode n = (InspectionTreeNode)node;
                    if (n.isLeaf()) {
                        SuppressActionWrapper.this.myNodesToSuppress.add(n);
                    }
                    return true;
                }
            });
        }
        this.myToolWrapper = toolWrapper;
    }

    @NotNull
    public SuppressTreeAction[] getChildren(@Nullable AnActionEvent e) {
        SuppressIntentionAction[] suppressActions = InspectionManagerEx.getSuppressActions(this.myToolWrapper);
        if (suppressActions == null || suppressActions.length == 0) {
            SuppressTreeAction[] suppressTreeActionArray = new SuppressTreeAction[]{};
            if (suppressTreeActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/SuppressActionWrapper", "getChildren"));
            }
            return suppressTreeActionArray;
        }
        SuppressTreeAction[] actions = new SuppressTreeAction[suppressActions.length];
        for (int i = 0; i < suppressActions.length; ++i) {
            SuppressIntentionAction suppressAction = suppressActions[i];
            actions[i] = new SuppressTreeAction(suppressAction);
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/SuppressActionWrapper", "getChildren"));
        }
        return actions;
    }

    private boolean suppress(final PsiElement element, final CommonProblemDescriptor descriptor, final SuppressIntentionAction action, final RefEntity refEntity) {
        final PsiModificationTracker tracker = PsiManager.getInstance((Project)this.myProject).getModificationTracker();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)SuppressActionWrapper.this.myProject).commitAllDocuments();
                try {
                    long startModificationCount = tracker.getModificationCount();
                    PsiElement container = null;
                    if (action instanceof SuppressIntentionActionFromFix) {
                        container = ((SuppressIntentionActionFromFix)action).getContainer(element);
                    }
                    if (container == null) {
                        container = element;
                    }
                    if (action.isAvailable(SuppressActionWrapper.this.myProject, null, element)) {
                        action.invoke(SuppressActionWrapper.this.myProject, null, element);
                    }
                    if (startModificationCount != tracker.getModificationCount()) {
                        Set<GlobalInspectionContextImpl> globalInspectionContexts = SuppressActionWrapper.this.myManager.getRunningContexts();
                        for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                            context.ignoreElement(SuppressActionWrapper.this.myToolWrapper.getTool(), container);
                            if (descriptor == null) continue;
                            context.getPresentation(SuppressActionWrapper.this.myToolWrapper).ignoreCurrentElementProblem(refEntity, descriptor);
                        }
                    }
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        });
        return true;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(InspectionManagerEx.getSuppressActions(this.myToolWrapper) != null);
    }

    private static Pair<PsiElement, CommonProblemDescriptor> getContentToSuppress(InspectionTreeNode node) {
        RefElement refElement = null;
        CommonProblemDescriptor descriptor = null;
        if (node instanceof RefElementNode) {
            RefElementNode elementNode = (RefElementNode)node;
            RefEntity element = elementNode.getElement();
            refElement = element instanceof RefElement ? (RefElement)element : null;
            descriptor = elementNode.getProblem();
        } else if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode descriptionNode = (ProblemDescriptionNode)node;
            RefEntity element = descriptionNode.getElement();
            refElement = element instanceof RefElement ? (RefElement)element : null;
            descriptor = descriptionNode.getDescriptor();
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement != null ? refElement.getElement() : null);
        return Pair.create((Object)element, descriptor);
    }

    public class SuppressTreeAction
    extends AnAction {
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(SuppressIntentionAction suppressAction) {
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(SuppressActionWrapper.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            for (InspectionTreeNode node : SuppressActionWrapper.this.myNodesToSuppress) {
                                Pair content = SuppressActionWrapper.getContentToSuppress(node);
                                if (content.first == null) break;
                                PsiElement element = (PsiElement)content.first;
                                RefEntity refEntity = null;
                                if (node instanceof RefElementNode) {
                                    refEntity = ((RefElementNode)node).getElement();
                                } else if (node instanceof ProblemDescriptionNode) {
                                    refEntity = ((ProblemDescriptionNode)node).getElement();
                                }
                                if (SuppressActionWrapper.this.suppress(element, (CommonProblemDescriptor)content.second, SuppressTreeAction.this.mySuppressAction, refEntity)) continue;
                                break;
                            }
                            Set<GlobalInspectionContextImpl> globalInspectionContexts = SuppressActionWrapper.this.myManager.getRunningContexts();
                            for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                                context.refreshViews();
                            }
                            CommandProcessor.getInstance().markCurrentCommandAsGlobal(SuppressActionWrapper.this.myProject);
                        }
                    }, SuppressTreeAction.this.getTemplatePresentation().getText(), null);
                }
            });
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (!this.isAvailable()) {
                e.getPresentation().setVisible(false);
            }
        }

        public boolean isAvailable() {
            for (InspectionTreeNode node : SuppressActionWrapper.this.myNodesToSuppress) {
                Pair content = SuppressActionWrapper.getContentToSuppress(node);
                if (content.first == null) continue;
                PsiElement element = (PsiElement)content.first;
                if (!this.mySuppressAction.isAvailable(SuppressActionWrapper.this.myProject, null, element)) continue;
                return true;
            }
            return false;
        }
    }
}

