/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.ExpandStateHandler;
import com.intellij.designer.componentTree.TreeContentProvider;
import com.intellij.designer.componentTree.TreeDropListener;
import com.intellij.designer.componentTree.TreeEditableArea;
import com.intellij.designer.designSurface.ComponentGlassLayer;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public final class ComponentTreeBuilder
extends AbstractTreeBuilder
implements ComponentSelectionListener {
    private final EditableArea mySurfaceArea;
    private final TreeEditableArea myTreeArea;
    private final ComponentGlassLayer myGlassLayer;
    private final ExpandStateHandler myExpandStateHandler;

    public ComponentTreeBuilder(ComponentTree tree, DesignerEditorPanel designer) {
        super((JTree)((Object)tree), (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)new TreeContentProvider(designer), null);
        this.setPassthroughMode(true);
        this.setCanYieldUpdate(false);
        this.initRootNode();
        this.mySurfaceArea = designer.getSurfaceArea();
        this.myTreeArea = new TreeEditableArea(tree, this, designer.getActionPanel());
        this.myGlassLayer = new ComponentGlassLayer((JComponent)((Object)tree), designer.getToolProvider(), this.myTreeArea);
        this.myExpandStateHandler = new ExpandStateHandler(tree, designer, this);
        tree.setArea(this.myTreeArea);
        designer.handleTreeArea(this.myTreeArea);
        new TreeDropListener(tree, this.myTreeArea, designer.getToolProvider());
        this.selectFromSurface();
        this.expandFromState();
        this.addListeners();
        this.myExpandStateHandler.hookListener();
    }

    public TreeEditableArea getTreeArea() {
        return this.myTreeArea;
    }

    public void dispose() {
        this.removeListeners();
        this.myTreeArea.unhookSelection();
        this.myGlassLayer.dispose();
        this.myExpandStateHandler.unhookListener();
        super.dispose();
    }

    private void addListeners() {
        this.mySurfaceArea.addSelectionListener(this);
        this.myTreeArea.addSelectionListener(this);
    }

    private void removeListeners() {
        this.mySurfaceArea.removeSelectionListener(this);
        this.myTreeArea.removeSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged(EditableArea area) {
        block7: {
            try {
                this.removeListeners();
                if (this.mySurfaceArea == area) {
                    try {
                        this.myTreeArea.setCanvasSelection(true);
                        this.myTreeArea.setSelection(this.mySurfaceArea.getSelection());
                        break block7;
                    }
                    finally {
                        this.myTreeArea.setCanvasSelection(false);
                    }
                }
                this.mySurfaceArea.setSelection(this.myTreeArea.getSelection());
                this.mySurfaceArea.scrollToSelection();
            }
            finally {
                this.addListeners();
            }
        }
    }

    public void selectFromSurface() {
        this.myTreeArea.setSelection(this.mySurfaceArea.getSelection());
    }

    public void expandFromState() {
        this.expand(this.myExpandStateHandler.getExpanded(), null);
    }
}

