/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GroupedLogMessage
extends AbstractMessage {
    private final List<AbstractMessage> myMessages;

    public GroupedLogMessage(List<AbstractMessage> messages) {
        this.myMessages = messages;
    }

    public List<AbstractMessage> getMessages() {
        return this.myMessages;
    }

    @Override
    public String getThrowableText() {
        StringBuilder result = new StringBuilder();
        for (AbstractMessage each : this.myMessages) {
            result.append(each.getThrowableText()).append("\n\n\n");
        }
        return result.toString();
    }

    @Override
    public void setRead(boolean aReadFlag) {
        for (AbstractMessage message : this.myMessages) {
            message.setRead(aReadFlag);
        }
        super.setRead(aReadFlag);
    }

    @Override
    public Throwable getThrowable() {
        return this.myMessages.get(0).getThrowable();
    }

    @Override
    public String getMessage() {
        return this.myMessages.get(0).getMessage();
    }

    @Override
    public void setAssigneeId(Integer assigneeId) {
        for (AbstractMessage message : this.myMessages) {
            message.setAssigneeId(assigneeId);
        }
        super.setAssigneeId(assigneeId);
    }

    @Override
    @NotNull
    public List<Attachment> getAttachments() {
        List list = ContainerUtil.concat(this.getMessages(), (Function)new Function<AbstractMessage, Collection<? extends Attachment>>(){

            public Collection<? extends Attachment> fun(AbstractMessage message) {
                return message.getAttachments();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/GroupedLogMessage", "getAttachments"));
        }
        return list;
    }
}

