/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RangesDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final List<? extends DiffIterableUtil.Range> myRanges;

    public RangesDiffIterable(@NotNull List<? extends DiffIterableUtil.Range> ranges, int length1, int length2) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/comparison/iterables/RangesDiffIterable", "<init>"));
        }
        super(length1, length2);
        this.myRanges = ranges;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        RangesChangeIterable rangesChangeIterable = new RangesChangeIterable();
        if (rangesChangeIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/RangesDiffIterable", "createChangeIterable"));
        }
        return rangesChangeIterable;
    }

    private class RangesChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private int myIndex = 0;

        private RangesChangeIterable() {
        }

        @Override
        public boolean valid() {
            return this.myIndex != RangesDiffIterable.this.myRanges.size();
        }

        @Override
        public void next() {
            ++this.myIndex;
        }

        @Override
        public int getStart1() {
            return ((DiffIterableUtil.Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).start1;
        }

        @Override
        public int getStart2() {
            return ((DiffIterableUtil.Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).start2;
        }

        @Override
        public int getEnd1() {
            return ((DiffIterableUtil.Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).end1;
        }

        @Override
        public int getEnd2() {
            return ((DiffIterableUtil.Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).end2;
        }
    }
}

